/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.util;

import cn.com.yusys.icsp.commons.util.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.helpers.MessageFormatter;

public final class CommonUtil {
    public static final boolean isNullOrEmpty(Collection<?> collection) {
        return Objects.isNull(collection) || collection.isEmpty();
    }

    public static final boolean nonNullOrEmpty(Collection<?> collection) {
        return Objects.nonNull(collection) && !collection.isEmpty();
    }

    public static final boolean isNullOrEmpty(Map<?, ?> map) {
        return Objects.isNull(map) || map.isEmpty();
    }

    public static final boolean nonNullOrEmpty(Map<?, ?> map) {
        return Objects.nonNull(map) && !map.isEmpty();
    }

    public static final boolean nonNull(Object object) {
        return Objects.nonNull(object) && StringUtil.isNotEmpty(StringUtil.replaceNullByObj(object));
    }

    public static final boolean nonNullOrEmpty(Object[] objects) {
        return Objects.nonNull(objects) && objects.length > 0;
    }

    public static final boolean isNullOrEmpty(Object[] objects) {
        return Objects.isNull(objects) || objects.length < 1;
    }

    public static final <T> T ofNullableElse(T srcObject, T elseObject) {
        return Optional.ofNullable(srcObject).orElse(elseObject);
    }

    public static final Map<String, Object> removeNullValue(Map<String, Object> paramObject) {
        ConcurrentHashMap<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
        if (Objects.nonNull(paramObject) && !paramObject.isEmpty()) {
            paramObject.entrySet().parallelStream().filter(s -> CommonUtil.nonNull(s.getValue())).forEach(s -> dataMap.put((String)s.getKey(), s.getValue()));
        }
        return dataMap;
    }

    public static final Map<String, Object> removeKeys(Map<String, Object> paramMap, String ... keys) {
        ConcurrentHashMap<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
        if (CommonUtil.nonNullOrEmpty(paramMap) && CommonUtil.nonNullOrEmpty(keys)) {
            List<String> listKey = Arrays.asList(keys);
            paramMap.entrySet().parallelStream().filter(s -> !listKey.contains(s.getKey())).forEach(s -> dataMap.put((String)s.getKey(), s.getValue()));
        }
        return dataMap;
    }

    public static final boolean exists(Object object, Object ... objects) {
        if (objects == null && object == null) {
            return true;
        }
        return CommonUtil.nonNullOrEmpty(objects) ? Arrays.stream(objects).filter(s -> s.equals(object)).count() > 0L : false;
    }

    public static final String formatMessage(String messagePattern, Object ... objects) {
        return MessageFormatter.arrayFormat((String)messagePattern, (Object[])objects).getMessage();
    }
}

