/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.util.ClassUtils;

public class BeanUtil {
    public static final <T> T beanCopy(Object source, T target) {
        if (Objects.nonNull(target) && Objects.nonNull(source)) {
            BeanCopier beanCopier = BeanCopier.create(source.getClass(), target.getClass(), (boolean)false);
            beanCopier.copy(source, target, null);
            return target;
        }
        return null;
    }

    public static final <T> T beanCopy(Object source, Class<T> target) {
        if (Objects.nonNull(target) && Objects.nonNull(source)) {
            BeanCopier beanCopier = BeanCopier.create(source.getClass(), target, (boolean)false);
            Object t = BeanUtil.newInstance(target);
            beanCopier.copy(source, t, null);
            return (T)t;
        }
        return null;
    }

    public static final <T> Collection<? extends Object> beansCopy(Collection<? extends Object> source, Class<?> target) {
        if (Objects.isNull(source) || Objects.isNull(target)) {
            return null;
        }
        if (source.isEmpty()) {
            return Collections.emptyList();
        }
        BeanCopier beanCopier = BeanCopier.create(source.iterator().next().getClass(), target, (boolean)false);
        ArrayList list = new ArrayList(source.size());
        source.forEach(s -> {
            Object t = BeanUtil.newInstance(target);
            beanCopier.copy(s, t, null);
            list.add(t);
        });
        return list;
    }

    public static final Object newInstance(Class<?> classt) {
        try {
            return classt.newInstance();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(BeanUtil.class).error("Class[" + classt + "]Exception in instantiation!", (Throwable)e);
            return null;
        }
    }

    public static final <T> T newInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(BeanUtil.class).error("Class[" + className + "]Exception in instantiation!", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setObjectFieldValue(Object object, Field field, Object value) {
        boolean isAccessible = field.isAccessible();
        try {
            if (!isAccessible) {
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(BeanUtil.class).error(e.getMessage());
        }
        finally {
            if (!isAccessible) {
                field.setAccessible(false);
            }
        }
    }

    public static final void setProptery(Object bean, String name, Object value) throws Exception {
        BeanUtils.setProperty((Object)bean, (String)name, (Object)value);
    }

    public static final Field getObjectFiled(Object bean, String name) throws Exception {
        Class<?> clazz = bean.getClass();
        return BeanUtil.getObjectFiled(clazz, name);
    }

    public static final Field getObjectFiled(Class<?> clazz, String name) throws Exception {
        while (Objects.nonNull(clazz) && !clazz.getName().equals("java.lang.Object")) {
            Field field = clazz.getDeclaredField(name);
            if (Objects.nonNull(field)) {
                return field;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object getObjectFieldValue(Object object, Field field) {
        boolean isAccessible = field.isAccessible();
        try {
            if (!isAccessible) {
                field.setAccessible(true);
            }
            Object object2 = field.get(object);
            return object2;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(BeanUtil.class).error(e.getMessage());
        }
        finally {
            if (!isAccessible) {
                field.setAccessible(false);
            }
        }
        return null;
    }

    public static final Object getObjectFieldValue(Object object, String clazzName, String fieldName) {
        try {
            Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)ClassUtils.getDefaultClassLoader());
            if (ClassUtils.isAssignableValue((Class)clazz, (Object)object)) {
                Field field = object.getClass().getDeclaredField(fieldName);
                return BeanUtil.getObjectFieldValue(object, field);
            }
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(BeanUtil.class).error(e.getMessage());
        }
        return null;
    }

    public static Object getProptery(Object object, String name) throws Exception {
        return BeanUtils.getProperty((Object)object, (String)name);
    }
}

