/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.mapper;

import cn.com.yusys.icsp.commons.util.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryModel {
    protected static final Logger logger = LoggerFactory.getLogger(QueryModel.class);
    private static final JavaType condMapType = TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class);
    @ApiModelProperty(value="jsonString\u6761\u4ef6\u5b57\u7b26\u4e32")
    private Map<String, Object> condition = new HashMap<String, Object>();
    private int page;
    private int size = 10;
    private String sort;
    @ApiModelProperty(hidden=true)
    private String formatedOrderBy;
    @ApiModelProperty(hidden=true)
    private String dataAuth;

    public Map<String, Object> getCondition() {
        return this.condition;
    }

    @JsonProperty
    public void setCondition(String condition) {
        ObjectMapper jsonObj = new ObjectMapper();
        try {
            this.condition = (Map)jsonObj.readValue(condition, condMapType);
        }
        catch (JsonParseException e) {
            logger.error("Error in converting query condition to map format", (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error("Error in converting query condition to map format", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error in converting query condition to map format", (Throwable)e);
        }
    }

    public void addCondition(String key, Object value) {
        this.condition.put(key, value);
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getSort() {
        return this.formatedOrderBy;
    }

    public void setSort(String sort) {
        this.sort = sort;
        this.formateOrderBy(this.sort);
    }

    private void formateOrderBy(String orderBy) {
        String[] orders;
        if (orderBy == null || "".equals(orderBy.trim())) {
            return;
        }
        StringBuilder formatedOrderBy = new StringBuilder();
        for (String order : orders = orderBy.split(",")) {
            String type;
            String field;
            String[] items = order.trim().split("\\s+|\\t+");
            if (items.length > 2) {
                logger.error("orderBy[" + orderBy + "] illegal field, no splicing");
                return;
            }
            if (items.length >= 1 && ("and".equalsIgnoreCase((field = items[0]).trim()) || "or".equalsIgnoreCase(field.trim()))) {
                logger.error("orderBy[" + orderBy + "] illegal field, no splicing");
                return;
            }
            if (items.length >= 2 && !"asc".equalsIgnoreCase(type = items[1]) && !"desc".equals(type)) {
                logger.error("orderBy[" + orderBy + "] illegal field, no splicing");
                return;
            }
            formatedOrderBy.append(StringUtil.hump2Underline(items[0]));
            if (items.length > 1) {
                formatedOrderBy.append(" " + items[1]);
            }
            formatedOrderBy.append(",");
        }
        String newOrderBy = formatedOrderBy.toString();
        if (newOrderBy.endsWith(",")) {
            newOrderBy = newOrderBy.substring(0, newOrderBy.length() - 1);
        }
        this.formatedOrderBy = newOrderBy;
    }

    public String getDataAuth() {
        return this.dataAuth;
    }

    public void setDataAuth(String dataAuth) {
        this.dataAuth = dataAuth;
    }
}

