/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.exception;

import cn.com.yusys.icsp.commons.exception.Message;
import cn.com.yusys.icsp.commons.util.CommonUtil;
import cn.com.yusys.icsp.commons.util.DateUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class IcspException
extends RuntimeException {
    private static final long serialVersionUID = 1088570243487187197L;
    private Map<String, Object> head = new LinkedHashMap<String, Object>();
    private Map<String, Object> body;

    public IcspException(String requestSeq, String code, String message, Throwable cause, Object ... args) {
        super(CommonUtil.formatMessage(message, args), cause);
        this.head.put("requestSeq", requestSeq);
        this.head.put("responseDate", DateUtil.formatDateTimeByDef());
        this.head.put("responseCode", code);
        this.head.put("responseMes", CommonUtil.formatMessage(message, args));
        this.head.put("totalSize", -1);
    }

    public IcspException(String requestSeq, String code, String message, Throwable e) {
        this(requestSeq, code, message, e, null);
    }

    public IcspException(String code, String message) {
        this(null, code, message, null, null);
    }

    public IcspException(String requestSeq, String code, String message) {
        this(requestSeq, code, message, null, null);
    }

    public IcspException(String code, Throwable e) {
        this(null, code, Objects.nonNull(e) ? e.getMessage() : null, e, null);
    }

    public IcspException(String requestSeq, String code, Throwable e) {
        this(requestSeq, code, Objects.nonNull(e) ? e.getMessage() : null, e, null);
    }

    public IcspException(String code, String message, Object ... args) {
        this(null, code, message, null, args);
    }

    public IcspException(String requestSeq, String code, String message, Object ... args) {
        this(requestSeq, code, message, null, args);
    }

    public IcspException(Message message, Object ... args) {
        this(null, message.getCode(), message.getMessage(), null, args);
    }

    public IcspException(String requestSeq, Message message, Object ... args) {
        this(requestSeq, message.getCode(), message.getMessage(), null, args);
    }

    public String getResponseCode() {
        Object code = this.head.get("responseCode");
        if (code instanceof String) {
            return (String)code;
        }
        if (code instanceof Integer) {
            return String.valueOf(code);
        }
        return null;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    public String getRequestSeq() {
        return (String)this.head.get("requestSeq");
    }

    public String getResponseMes() {
        return (String)this.head.get("responseMes");
    }
}

