/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.config;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.context.annotation.Configuration;

public class DynamicRefreshLogLevelAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DynamicRefreshLogLevelAutoConfiguration.class);
    private static final String LOGGER_TAG = "logging.level.";
    @Autowired
    private LoggingSystem loggingSystem;

    private void onChange(Config config, ConfigChangeEvent event) {
        Set loggingKeys = event.changedKeys();
        HashMap<String, String> loggings = new HashMap<String, String>();
        loggingKeys.forEach(s -> loggings.put((String)s, config.getProperty(s, "info")));
        this.refreshLoggingLevels(loggings);
    }

    private void refreshLoggingLevels(Map<String, String> loggings) {
        for (String key : loggings.keySet()) {
            String level = loggings.get(key);
            LogLevel logLevel = LogLevel.valueOf((String)level.toUpperCase());
            this.loggingSystem.setLogLevel(key.replace(LOGGER_TAG, ""), logLevel);
            logger.info("{}:{}", (Object)key, (Object)level);
        }
    }

    @Configuration
    @ConditionalOnExpression(value="'${apollo.bootstrap.namespaces}'.contains('application.yaml')")
    public class YamlRefreshLogLevel {
        @ApolloConfig(value="application.yaml")
        private Config config;

        @ApolloConfigChangeListener(interestedKeyPrefixes={"logging.level."}, value={"application.yaml"})
        private void onChange(ConfigChangeEvent changeEvent) {
            logger.info("yml configuration modify log level...");
            DynamicRefreshLogLevelAutoConfiguration.this.onChange(this.config, changeEvent);
        }
    }

    @Configuration
    @ConditionalOnExpression(value="'${apollo.bootstrap.namespaces}'.contains('application.yml')")
    public class YmlRefreshLogLevel {
        @ApolloConfig(value="application.yml")
        private Config config;

        @ApolloConfigChangeListener(interestedKeyPrefixes={"logging.level."}, value={"application.yml"})
        private void onChange(ConfigChangeEvent changeEvent) {
            logger.info("yml configuration modify log level...");
            DynamicRefreshLogLevelAutoConfiguration.this.onChange(this.config, changeEvent);
        }
    }

    @Configuration
    public class PropertiesRefreshLogLevel {
        @ApolloConfig
        private Config config;

        @ApolloConfigChangeListener(interestedKeyPrefixes={"logging.level."})
        private void onChange(ConfigChangeEvent changeEvent) {
            logger.info("Properties configuration modify log level...");
            DynamicRefreshLogLevelAutoConfiguration.this.onChange(this.config, changeEvent);
        }
    }
}

