/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.log.dbpool.collect;

import cn.com.yusys.icsp.commons.log.dbpool.DbPoolLogger;
import cn.com.yusys.icsp.commons.log.dbpool.collect.LocalLogDbPoolMetricsEndpoint;
import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DbPoolLoggerTask
implements SchedulingConfigurer {
    private final Logger log = LoggerFactory.getLogger(DbPoolLoggerTask.class);
    @Value(value="${application.log.dbpool.enable:true}")
    private Boolean isSwitch;
    @Value(value="${application.log.dbpool.collectFreq:0/2 * * * * ?}")
    private String cron;
    @Autowired
    private LocalLogDbPoolMetricsEndpoint localLogDbPoolMetricsEndpoint;

    protected void writeLog() {
        try {
            this.log.debug("dbpool begin collect!");
            Map<String, Object> map = this.localLogDbPoolMetricsEndpoint.getDbPoolEntityByDbParams();
            if (!CollectionUtils.isEmpty(map)) {
                map.put("timestamp", new Date().getTime());
                DbPoolLogger.info(map);
            } else {
                this.log.warn(JSON.toJSONString(map));
            }
        }
        catch (Exception var2) {
            this.log.error(var2.getMessage(), (Throwable)var2);
        }
    }

    protected String getCron() {
        return this.cron;
    }

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        this.log.debug("dbpool\u5f00\u5173isSwitch=" + this.isSwitch);
        if (this.isSwitch.booleanValue()) {
            scheduledTaskRegistrar.addTriggerTask(() -> {
                try {
                    this.writeLog();
                }
                catch (Exception var2) {
                    this.log.error(var2.getMessage(), (Throwable)var2);
                }
            }, triggerContext -> {
                if (StringUtils.isEmpty((Object)this.cron)) {
                    this.cron = this.getCron();
                }
                CronTrigger trigger = new CronTrigger(this.cron);
                return trigger.nextExecutionTime(triggerContext);
            });
        }
    }
}

