/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.log.env.collect;

import cn.com.yusys.icsp.commons.log.env.EnvLogger;
import cn.com.yusys.icsp.commons.log.env.collect.LocalLogEnvAndConfigEndpoint;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.util.StringUtils;

public class EnvLoggerTask
implements SchedulingConfigurer,
DisposableBean {
    private final Logger log = LoggerFactory.getLogger(EnvLoggerTask.class);
    private boolean shutdown = false;
    @Value(value="${application.log.env.collectFreq:0/60 * * * * ?}")
    private String cron;
    @Autowired
    private LocalLogEnvAndConfigEndpoint localLogEnvironmentAndConfigEndpoint;

    protected void writeLog() {
        try {
            this.log.debug("env begin collect!");
            Map<String, Object> result = this.localLogEnvironmentAndConfigEndpoint.getEnvAndConfigDataMap();
            EnvLogger.info(result);
        }
        catch (Exception var2) {
            this.log.error("env monitor info get error", (Throwable)var2);
        }
    }

    protected String getCron() {
        return this.cron;
    }

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        scheduledTaskRegistrar.addTriggerTask(() -> {
            try {
                if (this.shutdown) {
                    this.log.info("shutdown env log task");
                    scheduledTaskRegistrar.destroy();
                } else {
                    this.writeLog();
                }
            }
            catch (Exception var3) {
                this.log.error("writeLog error", (Throwable)var3);
            }
        }, triggerContext -> {
            if (StringUtils.isEmpty((Object)this.cron)) {
                this.cron = this.getCron();
            }
            CronTrigger trigger = new CronTrigger(this.cron);
            return trigger.nextExecutionTime(triggerContext);
        });
    }

    public void destroy() throws Exception {
        this.shutdown = true;
    }
}

