/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.es.publisher;

import cn.com.yusys.es.event.DomainEventEntry;
import cn.com.yusys.es.event.DomainEventEntryRepository;
import cn.com.yusys.es.publisher.DomainEventEntryPublisher;
import java.text.MessageFormat;
import java.util.Collection;
import net.javacrumbs.shedlock.core.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;

public class ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleService.class);
    @Autowired
    DomainEventEntryRepository domainEventEntryRepository;
    @Autowired
    DomainEventEntryPublisher domainEventEntryPublisher;

    @Scheduled(cron="0 0 12 * * ?")
    @SchedulerLock(name="failedMessageDiscoveryTask")
    public void failedMessageDiscovery() {
        int page = 0;
        PageRequest request = PageRequest.of((int)page, (int)1000);
        Page<DomainEventEntry> results = this.domainEventEntryRepository.findBySentFalse((Pageable)request);
        log.warn(MessageFormat.format("\u53d1\u73b0 [{0}] \u6761\u5931\u8d25\u6d88\u606f\uff0c\u5c1d\u8bd5\u91cd\u65b0\u53d1\u9001", results.getTotalElements()));
        this.sendFailedMessage(results.getContent());
        while (results.hasNext()) {
            request = PageRequest.of((int)(page + 1), (int)1000);
            results = this.domainEventEntryRepository.findBySentFalse((Pageable)request);
            this.sendFailedMessage(results.getContent());
        }
        log.info("\u6240\u6709\u5931\u8d25\u6d88\u606f\u5c1d\u8bd5\u53d1\u9001\u5b8c\u6bd5");
    }

    private void sendFailedMessage(Collection<DomainEventEntry> failedEvents) {
        failedEvents.forEach(e -> {
            boolean isSend = this.domainEventEntryPublisher.sendEvent((DomainEventEntry)e);
            if (isSend) {
                e.setSent(true);
                this.domainEventEntryRepository.save(e);
            }
        });
    }
}

