/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.test;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import com.shch.sfc.application.SfcBootApplication;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;

@SfcBootApplication
public class TestApplication {
    @Bean
    public TracerRunner tracerRunner() {
        return new TracerRunner();
    }

    static class TracerRunner
    implements ApplicationContextAware,
    ApplicationRunner {
        static final Propagation.Getter<Map<String, String>, String> GETTER = new Propagation.Getter<Map<String, String>, String>(){

            public String get(Map<String, String> carrier, String key) {
                return carrier.get(key);
            }

            public String toString() {
                return "custom::setHeader";
            }
        };
        private ApplicationContext applicationContext;

        TracerRunner() {
        }

        public void run(ApplicationArguments args) throws Exception {
            Tracing tracing = (Tracing)this.applicationContext.getBean(Tracing.class);
            TraceContext.Extractor extractor = tracing.propagation().extractor(GETTER);
            TraceContextOrSamplingFlags extracted = extractor.extract(new HashMap());
            Tracer tracer = tracing.tracer();
            Span consumerSpan = tracer.nextSpan(extracted).kind(Span.Kind.SERVER).name("test-context");
            tracer.withSpanInScope(consumerSpan);
        }

        public void setApplicationContext(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }
    }
}

