/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.test;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.shch.sfc.core.context.SfcContext;
import com.shch.sfc.test.TestApplication;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.springframework.boot.test.autoconfigure.web.reactive.AutoConfigureWebTestClient;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;

@SpringBootTest(classes={TestApplication.class})
@AutoConfigureWebTestClient
public abstract class AbstractTestNGTests
extends AbstractTestNGSpringContextTests {
    public static final String DP = "defaultProvider";
    private static final String SQL_BEFORE = "before.sql";
    private static final String SQL_AFTER = "after.sql";
    private static final String URL_SLIPT = "/";
    @Resource
    protected JdbcTemplate jdbc;
    private String packageResPath = ((Object)((Object)this)).getClass().getPackage().getName().replace("com.shch.", "testcase.").replace(".", "/") + "/";
    private String classResPath = this.packageResPath + ((Object)((Object)this)).getClass().getSimpleName() + "/";
    private SfcContext oldContext = null;

    protected AbstractTestNGTests() {
    }

    @BeforeClass(alwaysRun=true)
    public void commonBeforeTestClass() {
        this.logger.info((Object)("\u6d4b\u8bd5\u7c7b" + ((Object)((Object)this)).getClass().getSimpleName() + "\u5f00\u59cb\u8fd0\u884c ..."));
        this.executeSql(this.classResPath + SQL_BEFORE, true);
        SfcContext newContext = this.initContext();
        if (newContext != null) {
            this.oldContext = SfcContext.set((SfcContext)newContext);
        }
    }

    @AfterClass(alwaysRun=true)
    public void commonAfterTestClass() {
        if (this.oldContext != null) {
            SfcContext.set((SfcContext)this.oldContext);
        }
        this.executeSql(this.classResPath + SQL_AFTER, true);
        this.logger.info((Object)("\u6d4b\u8bd5\u7c7b" + ((Object)((Object)this)).getClass().getSimpleName() + "\u8fd0\u884c\u7ed3\u675f"));
    }

    @BeforeMethod(alwaysRun=true)
    public void commonBeforeTestMethod(Method m) {
        String beforeSql = this.classResPath + m.getName() + URL_SLIPT + SQL_BEFORE;
        this.executeSql(beforeSql, true);
    }

    @AfterMethod(alwaysRun=true)
    public void commonAfterTestMethod(Method m) {
        String afterSql = this.classResPath + m.getName() + URL_SLIPT + SQL_AFTER;
        this.executeSql(afterSql, true);
    }

    @DataProvider(name="defaultProvider")
    public Object[][] createMethodData(Method m) {
        if (m.getParameterCount() == 0) {
            return new Object[0][0];
        }
        return new Object[][]{this.createParamters(m).toArray()};
    }

    protected SfcContext initContext() {
        return null;
    }

    private List<Object> createParamters(Method m) {
        ArrayList<Object> retList = new ArrayList<Object>();
        String methodResPath = this.classResPath + m.getName() + URL_SLIPT;
        for (Class<?> parameterType : m.getParameterTypes()) {
            String fileName = parameterType.getSimpleName() + ".json";
            ClassPathResource resource = new ClassPathResource(methodResPath + fileName);
            if (!resource.exists()) {
                resource = new ClassPathResource(this.classResPath + fileName);
            }
            if (!resource.exists()) {
                resource = new ClassPathResource(this.packageResPath + fileName);
            }
            if (!resource.exists()) {
                this.assertFail("\u65e0\u6cd5\u83b7\u53d6JSON\u6570\u636e\u6587\u4ef6\uff0cclass=" + ((Object)((Object)this)).getClass().getName() + ",method=" + m.getName() + ", argType=" + parameterType.getSimpleName());
            }
            try {
                Object obj = this.createParameterFromJson(resource, parameterType);
                retList.add(obj);
            }
            catch (IOException e) {
                this.assertFail(e);
            }
        }
        return retList;
    }

    private Object createParameterFromJson(ClassPathResource resource, Class<?> classType) throws IOException {
        try (InputStream is = resource.getInputStream();){
            Object object = JSON.parseObject((InputStream)is, classType, (Feature[])new Feature[0]);
            return object;
        }
    }

    private void executeSql(String sqlPath, boolean ignoreNotFound) {
        try {
            List<String> sqlList = this.parseSQL(sqlPath, ignoreNotFound);
            for (String sql : sqlList) {
                this.jdbc.execute(sql);
            }
        }
        catch (Exception e) {
            this.assertFail(e);
        }
    }

    private List<String> parseSQL(String sqlPath, boolean ignoreNotFound) throws IOException {
        ArrayList<String> sqlList = new ArrayList<String>();
        ClassPathResource resource = new ClassPathResource(sqlPath);
        if (!resource.exists()) {
            if (ignoreNotFound) {
                return sqlList;
            }
            throw new IllegalStateException(sqlPath + "\u4e0d\u5b58\u5728");
        }
        StringBuilder sb = new StringBuilder();
        for (String line : FileUtils.readLines((File)resource.getFile(), (Charset)StandardCharsets.UTF_8)) {
            if (line.matches("^\\s*\\-\\-.*$")) continue;
            if (line.trim().endsWith(";")) {
                line = line.trim();
                sb.append(" ");
                sb.append(line.substring(0, line.length() - 1));
                sqlList.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(" ");
            sb.append(line);
        }
        return sqlList;
    }

    private void assertFail(String message) {
        this.logger.error((Object)message);
        Assert.fail((String)message);
    }

    private void assertFail(Exception e) {
        this.logger.error((Object)e.getMessage(), (Throwable)e);
        Assert.fail((String)e.getMessage(), (Throwable)e);
    }
}

