/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.task.base;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskRequest;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResponse;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResult;
import cn.com.yusys.yusp.batch.dbo.taskcenter.spring.task.SpringDboTask;
import com.shch.sfc.components.job.api.BasePlatformApi;
import com.shch.sfc.components.job.vo.DboTaskRequestWrap;
import java.util.Date;

public abstract class AbstractDboRemoteStateSyncTask
implements SpringDboTask {
    public DboTaskResponse execute(DboTaskRequest dboTaskRequest) {
        DboTaskRequestWrap requestWrap = new DboTaskRequestWrap(dboTaskRequest);
        requestWrap.getDboTaskContext().setTaskStartTime(new Date());
        DboTaskResponse response = this.executeTask(requestWrap);
        this.remoteStateSync(requestWrap, response);
        return response;
    }

    private void remoteStateSync(DboTaskRequestWrap requestWrap, DboTaskResponse response) {
        if (requestWrap.getBizDay() != null) {
            switch (requestWrap.getTaskType()) {
                case NormalTask: {
                    this.sendSyncMessage(requestWrap, response);
                    break;
                }
                case DataPartition: {
                    if (response.getTaskResult() == DboTaskResult.Success) break;
                    this.sendSyncMessage(requestWrap, response);
                    break;
                }
                case PartitionTask: {
                    if (response.getTaskResult() == DboTaskResult.Success && !requestWrap.getDboTaskContext().isAllPartitionsSuccess()) break;
                    this.sendSyncMessage(requestWrap, response);
                }
            }
        }
    }

    private void sendSyncMessage(DboTaskRequestWrap requestWrap, DboTaskResponse response) {
        BasePlatformApi.TaskResult result = new BasePlatformApi.TaskResult();
        result.setJobId(requestWrap.getJobId());
        result.setTaskId(requestWrap.getTaskId());
        result.setStartTime(requestWrap.getDboTaskContext().getTaskStartTime());
        result.setEndTime(new Date());
        result.setExecMode(requestWrap.getTaskExecMode());
        result.setStatus(response.getTaskResult() == DboTaskResult.Success ? "S" : "E");
        result.setTaskMessage(response.getTaskMessage());
        result.setTaskDay(requestWrap.getTaskDay());
        result.setBizDay(requestWrap.getBizDay());
        BasePlatformApi.syncTaskResult(result);
    }

    protected abstract DboTaskResponse executeTask(DboTaskRequestWrap var1);
}

