/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.checker;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResponse;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResult;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.shch.sfc.components.job.checker.DboPartitionTaskLogChecker;
import com.shch.sfc.components.job.checker.DboTaskChecker;
import com.shch.sfc.components.job.ex.TaskPreCheckException;
import com.shch.sfc.components.job.vo.DboCheckResultInfo;
import com.shch.sfc.components.job.vo.DboTaskRequestWrap;
import com.shch.sfc.components.job.vo.PreCheckResult;
import java.util.Collections;
import java.util.List;

public class DboCheckManager {
    public void preCheck(List<DboTaskChecker> list, DboTaskRequestWrap request, List<DboCheckResultInfo> resultInfoList) throws TaskPreCheckException {
        for (DboTaskChecker checker : list) {
            PreCheckResult result = checker.preCheck(request);
            resultInfoList.add(new DboCheckResultInfo(checker, result));
            if (result.getCheckSuccess().booleanValue()) continue;
            break;
        }
    }

    public DboTaskResponse postCheck(List<DboCheckResultInfo> list, DboTaskRequestWrap request, DboTaskResponse response) {
        if (list != null) {
            DboCheckResultInfo partitionTaskCheckResultInfo = null;
            for (DboCheckResultInfo resultInfo : list) {
                if (!(resultInfo.getTaskChecker() instanceof DboPartitionTaskLogChecker)) continue;
                partitionTaskCheckResultInfo = resultInfo;
                break;
            }
            if (partitionTaskCheckResultInfo != null) {
                list.add(partitionTaskCheckResultInfo);
            }
            Collections.reverse(list);
            boolean isCheckPostFailed = false;
            boolean partitionTaskChecked = false;
            for (DboCheckResultInfo resultInfo : list) {
                if (resultInfo.getTaskChecker() == null) continue;
                if (resultInfo == partitionTaskCheckResultInfo) {
                    if (!partitionTaskChecked) {
                        partitionTaskChecked = true;
                    } else if (!isCheckPostFailed) continue;
                }
                try {
                    resultInfo.getTaskChecker().postCheck(resultInfo.getPreCheckResult(), request, response);
                }
                catch (Exception e) {
                    isCheckPostFailed = true;
                    if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
                        response.setTaskResult(DboTaskResult.Exception, e.getClass().getName());
                        continue;
                    }
                    response.setTaskResult(DboTaskResult.Exception, e.getMessage());
                }
            }
        }
        return response;
    }
}

