/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.BillTemplate;
import cn.com.yusys.yusp.commons.excelcsv.CsvTemplate;
import cn.com.yusys.yusp.commons.excelcsv.ExcelTemplate;
import cn.com.yusys.yusp.commons.excelcsv.ITemplate;
import cn.com.yusys.yusp.commons.excelcsv.XmlTemplate;
import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.file.api.FileInfo;
import cn.com.yusys.yusp.commons.file.util.FileInfoUtils;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import com.shch.sfc.components.excelcsv.AbstractEfDataHandle;
import com.shch.sfc.components.excelcsv.TemplateManager;
import com.shch.sfc.core.context.SfcContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExporterImporter {
    private static final Logger log = LoggerFactory.getLogger(ExporterImporter.class);
    public static final List<String> FILE_TYPE_LIST = Collections.unmodifiableList(Arrays.asList("csv", "xls", "xlsx"));
    private int sheetMaxRow;
    private final Map<String, ITemplate> templateMap = new ConcurrentHashMap<String, ITemplate>();

    public ExporterImporter() {
    }

    public ExporterImporter(int sheetMaxRow) {
        this.sheetMaxRow = sheetMaxRow;
    }

    public File export(Class<?> headClass, Object model) {
        return this.export(headClass, model, new AbstractEfDataHandle.DefaultDataHandle());
    }

    public File export(Class<?> headClass, Object model, AbstractEfDataHandle dataHandle) {
        return this.simpleExport(headClass, model, dataHandle, this.checkFileTypeInContext(true), ",");
    }

    public File exportCsv(Class<?> headClass, Object model, String delimiter) {
        return this.exportCsv(headClass, model, delimiter, new AbstractEfDataHandle.DefaultDataHandle());
    }

    public File exportCsv(Class<?> headClass, Object model, String delimiter, AbstractEfDataHandle dataHandle) {
        return this.simpleExport(headClass, model, dataHandle, "csv", delimiter);
    }

    private File simpleExport(Class<?> headClass, Object model, AbstractEfDataHandle dataHandle, String fileType, String delimiter) {
        Objects.requireNonNull(headClass, "headClass can not be null.");
        Objects.requireNonNull(model, "model can not be null.");
        Objects.requireNonNull(dataHandle, "dataHandle can not be null.");
        try {
            CsvTemplate iTemplate;
            File outFile = this.getOutFile(fileType);
            if ("csv".equals(fileType)) {
                log.info("export csv file.");
                iTemplate = new CsvTemplate(headClass, (DataHandle)dataHandle, delimiter);
            } else {
                log.info("export excel file.");
                iTemplate = new ExcelTemplate(headClass, this.sheetMaxRow, (DataHandle)dataHandle);
            }
            iTemplate.export(model, outFile);
            return outFile;
        }
        catch (Exception e) {
            throw new IllegalStateException("export failed.", e);
        }
    }

    public File export(Object model) {
        return this.export(this.checkFileTypeInContext(false), model);
    }

    public File export(String templateName, Object model) {
        return this.billExport(templateName, model);
    }

    public File export(File templateFile, Object model) {
        try {
            File outFile = this.getTmpOutFile(templateFile.getName());
            ITemplate iTemplate = this.templateMap.computeIfAbsent(templateFile.getName(), tName -> {
                if (tName.endsWith(".ftl") || tName.endsWith(".ftlx")) {
                    return new XmlTemplate(templateFile, (DataHandle)new AbstractEfDataHandle.DefaultDataHandle());
                }
                return new BillTemplate(templateFile, (DataHandle)new AbstractEfDataHandle.DefaultDataHandle());
            });
            iTemplate.export(this.getTemplateExportModel(model), outFile);
            return outFile;
        }
        catch (Exception e) {
            throw new IllegalStateException("export bill failed.", e);
        }
    }

    private File billExport(String templateName, Object model) {
        try {
            File outFile = this.getTmpOutFile(templateName);
            ITemplate iTemplate = this.templateMap.computeIfAbsent(templateName, tName -> TemplateManager.getInstance().readTemplate(templateName));
            iTemplate.export(this.getTemplateExportModel(model), outFile);
            return outFile;
        }
        catch (Exception e) {
            throw new IllegalStateException("export bill failed.", e);
        }
    }

    public <T> List<T> importData(Class<T> headClass, File inFile) {
        return this.importData(headClass, inFile, ",");
    }

    public <T> List<T> importData(Class<T> headClass, File inFile, String delimiter) {
        ArrayList importList = new ArrayList();
        this.importData(headClass, inFile, delimiter, rowData -> {
            if (rowData.getClass() == headClass) {
                importList.add(rowData);
            } else {
                log.warn("the row data is not the type {}", (Object)headClass.getName());
            }
        });
        return importList;
    }

    public void importData(Class<?> headClass, File inFile, Consumer<Object> handleFun) {
        this.importData(headClass, inFile, ",", handleFun);
    }

    public void importData(Class<?> headClass, File inFile, String delimiter, Consumer<Object> handleFun) {
        this.importData(headClass, inFile, delimiter, new AbstractEfDataHandle.DefaultDataHandle(), handleFun);
    }

    public void importData(Class<?> headClass, File inFile, String delimiter, AbstractEfDataHandle dataHandle, Consumer<Object> handleFun) {
        block4: {
            Objects.requireNonNull(headClass, "headClass can not be null.");
            Objects.requireNonNull(inFile, "file can not be null.");
            Objects.requireNonNull(dataHandle, "dataHandle can not be null.");
            Objects.requireNonNull(handleFun, "handleFun can not be null.");
            try {
                String fileName = inFile.getName().toLowerCase();
                if (fileName.endsWith(".csv")) {
                    CsvTemplate csvTemplate = new CsvTemplate(headClass, (DataHandle)dataHandle, delimiter);
                    csvTemplate.importData(inFile, handleFun);
                    break block4;
                }
                if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) {
                    ExcelTemplate excelTemplate = new ExcelTemplate(headClass, 1000, (DataHandle)dataHandle);
                    excelTemplate.importData(inFile, handleFun);
                    break block4;
                }
                throw new IllegalArgumentException("the file type " + fileName + " is not supported.");
            }
            catch (Exception e) {
                throw new IllegalStateException("import error.", e);
            }
        }
    }

    private String checkFileTypeInContext(boolean isSimple) {
        String exportFlag = SfcContext.get().getExportFlag();
        if (exportFlag == null) {
            throw new IllegalStateException("the export flag in context is null.");
        }
        if (isSimple && !FILE_TYPE_LIST.contains(exportFlag)) {
            throw new IllegalStateException("must specify an explicit export type [xls/xlsx/csv] in context");
        }
        if (!isSimple && FILE_TYPE_LIST.contains(exportFlag)) {
            throw new IllegalStateException("must specify an explicit template name in context or you can manually specify the template name");
        }
        return exportFlag;
    }

    public static FileInfo uploadTmpFile(File tempFile) {
        return FileInfoUtils.uploadTempFile((File)tempFile);
    }

    private File getTmpOutFile(String templateName) throws IOException {
        String outFileExtName;
        String templateExtName;
        switch (templateExtName = templateName.substring(templateName.lastIndexOf(".") + 1)) {
            case "ftl": {
                outFileExtName = "txt";
                break;
            }
            case "ftlx": {
                outFileExtName = "xml";
                break;
            }
            default: {
                outFileExtName = templateExtName;
            }
        }
        return this.getOutFile(outFileExtName);
    }

    private File getOutFile(String fileType) throws IOException {
        return File.createTempFile("shch-export-", "." + fileType);
    }

    private Object getTemplateExportModel(Object model) {
        try {
            return model instanceof String ? ObjectMapperUtils.instance().readValue((String)model, Map.class) : model;
        }
        catch (IOException e) {
            throw new IllegalStateException("read export json value error.", e);
        }
    }
}

