/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.task.base;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResponse;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResult;
import cn.com.yusys.yusp.commons.util.BooleanUtils;
import com.shch.sfc.components.job.checker.DboCheckManager;
import com.shch.sfc.components.job.checker.DboTaskChecker;
import com.shch.sfc.components.job.task.base.AbstractDboRemoteStateSyncTask;
import com.shch.sfc.components.job.tools.DboTaskTool;
import com.shch.sfc.components.job.vo.DboCheckResultInfo;
import com.shch.sfc.components.job.vo.DboTaskRequestWrap;
import com.shch.sfc.components.job.vo.PreCheckResult;
import com.shch.sfc.components.job.vo.TaskResponse;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDboCheckTask
extends AbstractDboRemoteStateSyncTask {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDboCheckTask.class);
    private final DboCheckManager dboCheckManager = new DboCheckManager();
    private final List<DboTaskChecker> checkerList = new ArrayList<DboTaskChecker>();

    public void assembleTaskChecker(List<DboTaskChecker> checkerList) {
        if (checkerList != null) {
            this.checkerList.addAll(checkerList);
        }
    }

    protected DboTaskResponse onPreCheckFailed(PreCheckResult checkResult) {
        return checkResult.getTaskResponse();
    }

    @Override
    protected DboTaskResponse executeTask(DboTaskRequestWrap requestWrap) {
        ArrayList<DboCheckResultInfo> resultInfoList = null;
        DboTaskResponse response = null;
        try {
            if (this.checkerList.size() > 0) {
                resultInfoList = new ArrayList<DboCheckResultInfo>();
                this.dboCheckManager.preCheck(this.checkerList, requestWrap, resultInfoList);
                for (DboCheckResultInfo resultInfo : resultInfoList) {
                    PreCheckResult checkResult = resultInfo.getPreCheckResult();
                    if (!BooleanUtils.isFalse((Boolean)checkResult.getCheckSuccess())) continue;
                    response = this.onPreCheckFailed(checkResult);
                    break;
                }
            }
            if (response == null) {
                TaskResponse taskResponse = this.onExecute(resultInfoList, requestWrap);
                if (taskResponse == null) {
                    logger.error("job-run-id:[{}] task-run-id:[{}] \u4e1a\u52a1\u6267\u884c\u8fd4\u56denull", (Object)requestWrap.getJobRunId(), (Object)requestWrap.getTaskRunId());
                    response = new DboTaskResponse();
                    response.setTaskResult(DboTaskResult.Unknown, "\u4e1a\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3anull");
                } else {
                    response = DboTaskTool.toDboTaskResponse(taskResponse);
                }
            }
        }
        catch (Exception e) {
            logger.error("job-run-id:[{}] task-run-id:[{}] Exception", new Object[]{requestWrap.getJobRunId(), requestWrap.getTaskRunId(), e});
            response = DboTaskTool.withException(e);
        }
        if (resultInfoList != null) {
            response = this.dboCheckManager.postCheck(resultInfoList, requestWrap, response);
        }
        return response;
    }

    protected TaskResponse onExecute(List<DboCheckResultInfo> resultInfoList, DboTaskRequestWrap dboTaskRequest) throws Exception {
        return this.onExecute(dboTaskRequest);
    }

    protected abstract TaskResponse onExecute(DboTaskRequestWrap var1) throws Exception;
}

