/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.model.IterableModel;
import cn.com.yusys.yusp.commons.file.api.FileInfo;
import cn.com.yusys.yusp.commons.file.util.FileInfoUtils;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import com.shch.sfc.components.excelcsv.AbstractEfDataHandle;
import com.shch.sfc.components.excelcsv.ExportContext;
import com.shch.sfc.components.excelcsv.ExportProxy;
import com.shch.sfc.components.excelcsv.ExporterImporter;
import com.shch.sfc.components.excelcsv.ModalInfo;
import com.shch.sfc.components.excelcsv.ProgressInfo;
import com.shch.sfc.core.context.SfcContext;
import com.shch.sfc.metadata.dict.Dicts;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import net.sf.cglib.core.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class ExportTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ExportTask.class);
    private final ExportContext ec;
    private final int maxPages;
    private final int pageSize;
    private String taskId;
    private String root;
    private ProgressInfo progressInfo;

    public ExportTask(ExportContext ec, int maxPages, int pageSize) {
        this.ec = ec;
        this.maxPages = maxPages;
        this.pageSize = pageSize <= 0 ? 5000 : pageSize;
        this.progressInfo = new ProgressInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.taskId = SfcContext.get().getAsyncJobId();
        this.progressInfo.setTaskId(this.taskId);
        File outFile = null;
        try {
            this.ec.progress.set(this.taskId, this.progressInfo);
            outFile = this.exportTask();
            log.info("export finished.");
            FileInfo fileInfo = ExporterImporter.uploadTmpFile(outFile);
            String fileInfoIdentity = FileInfoUtils.toIdentity((FileInfo)fileInfo);
            this.progressInfo.setProgressBar(100);
            this.progressInfo.setFileId(fileInfoIdentity);
            this.ec.progress.set(this.taskId, this.progressInfo);
        }
        catch (Throwable e) {
            log.error("error.", e);
            this.progressInfo.setProgressBar(-1);
            this.ec.progress.set(this.taskId, this.progressInfo);
        }
        finally {
            if (outFile != null && outFile.exists() && !outFile.delete()) {
                log.warn("temp file {} delete failed, please delete manually.", (Object)outFile.getPath());
            }
            Dicts.clearThreadLocal();
        }
    }

    public File exportTask() {
        ExportProxy exportProxy = this.ec.method.getAnnotation(ExportProxy.class);
        Class<? extends AbstractEfDataHandle> dataHandleClass = exportProxy.handle();
        this.root = exportProxy.root();
        Class<?> headClass = exportProxy.headClass();
        AbstractEfDataHandle dataHandle = (AbstractEfDataHandle)ReflectUtils.newInstance(dataHandleClass);
        IterableModel model = new IterableModel(this::queryResultByPage, this.maxPages);
        DataSourceTransactionManager transactionManager = (DataSourceTransactionManager)SpringContextUtils.getBean(DataSourceTransactionManager.class);
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setReadOnly(true);
        TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        try {
            File outFile = this.ec.exporterImporter.export(headClass, model, dataHandle);
            transactionManager.commit(transactionStatus);
            return outFile;
        }
        catch (Exception e) {
            transactionManager.rollback(transactionStatus);
            throw new IllegalStateException("export error.", e);
        }
    }

    private Collection<?> queryResultByPage(int pageNum) {
        try {
            SfcContext sfcContext = SfcContext.get();
            sfcContext.setPageNum(Integer.valueOf(pageNum)).setPageSize(Integer.valueOf(this.pageSize));
            Object ret = this.ec.proxy.invokeSuper(this.ec.obj, this.ec.args);
            Collection<?> resultModel = this.findCollectionModal(ret);
            int percent = (int)((double)pageNum / (double)this.maxPages * 100.0);
            this.progressInfo.setProgressBar(percent == 100 ? 99 : percent);
            long alreadyCount = this.progressInfo.getProcessRecord();
            this.progressInfo.setProcessRecord(alreadyCount + (long)resultModel.size());
            this.ec.progress.set(this.taskId, this.progressInfo);
            return resultModel;
        }
        catch (Throwable e) {
            this.progressInfo.setProgressBar(-1);
            this.ec.progress.set(this.taskId, this.progressInfo);
            log.error("error.", e);
            return Collections.emptyList();
        }
    }

    private Collection<?> findCollectionModal(Object obj) {
        Object modal = obj;
        if ((modal = ModalInfo.of(modal, this.root).getModalObject()) instanceof Collection) {
            return (Collection)modal;
        }
        return Collections.singletonList(modal);
    }
}

