/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.excelcsv;

import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.shch.sfc.components.excelcsv.ExportContext;
import com.shch.sfc.components.excelcsv.ExportPoolServiceExecutor;
import com.shch.sfc.components.excelcsv.ExportProxy;
import com.shch.sfc.components.excelcsv.ExporterImporter;
import com.shch.sfc.core.context.SfcContext;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.ClassUtils;

public class ExportProxyPostProcessor
implements BeanFactoryPostProcessor {
    private static Callback[] staticCallbacks = new Callback[]{new ExportInterceptor(), NoOp.INSTANCE};
    private static Class<?>[] staticCallbackTypes = new Class[]{MethodInterceptor.class, NoOp.class};

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            if (beanDefinition.isAbstract() || StringUtils.isBlank((CharSequence)beanDefinition.getBeanClassName())) continue;
            try {
                Class beanClazz = ClassUtils.forName((String)beanDefinition.getBeanClassName(), null);
                Class userClass = ClassUtils.getUserClass((Class)beanClazz);
                if (Stream.of(userClass.getDeclaredMethods()).noneMatch(method -> method.isAnnotationPresent(ExportProxy.class))) continue;
                Enhancer enhancer = this.createExportEnhancer(userClass);
                Class enhancerClass = enhancer.createClass();
                beanDefinition.setBeanClassName(enhancerClass.getName());
                Enhancer.registerStaticCallbacks((Class)enhancerClass, (Callback[])staticCallbacks);
            }
            catch (ClassNotFoundException e) {
                throw new CannotLoadBeanClassException(beanDefinition.getResourceDescription(), beanName, beanDefinition.getBeanClassName(), e);
            }
        }
    }

    private Enhancer createExportEnhancer(Class<?> superClass) {
        Enhancer enhancer = new Enhancer();
        enhancer.setInterceptDuringConstruction(false);
        enhancer.setSuperclass(superClass);
        enhancer.setInterfaces((Class[])superClass.getInterfaces());
        enhancer.setCallbackTypes((Class[])staticCallbackTypes);
        enhancer.setCallbackFilter(method -> {
            if (method.isAnnotationPresent(ExportProxy.class)) {
                return 0;
            }
            return 1;
        });
        return enhancer;
    }

    public static class ExportInterceptor
    implements MethodInterceptor {
        public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            String exportFlag = SfcContext.get().getExportFlag();
            if (exportFlag != null && ExporterImporter.FILE_TYPE_LIST.contains(exportFlag.toLowerCase())) {
                ExportPoolServiceExecutor serviceExecutor = (ExportPoolServiceExecutor)SpringContextUtils.getBean(ExportPoolServiceExecutor.class);
                ExportContext exportContext = new ExportContext();
                exportContext.obj = obj;
                exportContext.args = args;
                exportContext.method = method;
                exportContext.proxy = methodProxy;
                serviceExecutor.execute(exportContext, SfcContext.get().getSourceType());
                SfcContext.get().setAsyncJobId(StringUtils.uuid((boolean)true));
                return method.getReturnType().newInstance();
            }
            return methodProxy.invokeSuper(obj, args);
        }
    }
}

