/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.excelcsv;

import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.shch.sfc.components.excelcsv.IProgress;
import com.shch.sfc.components.excelcsv.ProgressInfo;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class DefaultRedisProgress
implements IProgress {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRedisProgress.class);
    private final StringRedisTemplate stringRedisTemplate;
    private static final String REDIS_GROUP_PREFIX = "ExcelCsvTask";
    private static final String SPLIT_SYMBOL = ":";
    private final long timeout;

    public DefaultRedisProgress(StringRedisTemplate stringRedisTemplate, long timeout) {
        Objects.requireNonNull(stringRedisTemplate, "StringRedisTemplate can not be null.");
        this.stringRedisTemplate = stringRedisTemplate;
        this.timeout = timeout;
    }

    @Override
    public void set(String taskId, ProgressInfo progressDto) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            logger.warn("the task id is blank. please check.");
            return;
        }
        String key = "ExcelCsvTask:" + taskId;
        try {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)ObjectMapperUtils.instance().writeValueAsString((Object)progressDto), this.timeout, TimeUnit.MINUTES);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("set export progress failed.", e);
        }
    }

    @Override
    public ProgressInfo progress(String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            logger.warn("the task id is blank. please check.");
            return null;
        }
        String key = "ExcelCsvTask:" + taskId;
        String result = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        try {
            return (ProgressInfo)ObjectMapperUtils.instance().readValue(result, ProgressInfo.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("read export progress failed.", e);
        }
    }
}

