/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.service.impl;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboPartitionRuleData;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskRequest;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResult;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.shch.sfc.components.job.mapper.PartitionTaskLogMapper;
import com.shch.sfc.components.job.po.PartitionTaskLogPO;
import com.shch.sfc.components.job.service.PartitionTaskLogService;
import com.shch.sfc.components.job.tools.DboTaskTool;
import com.shch.sfc.components.job.vo.TaskStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="partitionTaskLogService")
public class PartitionTaskLogServiceImpl
extends ServiceImpl<PartitionTaskLogMapper, PartitionTaskLogPO>
implements PartitionTaskLogService {
    private static final Logger log = LoggerFactory.getLogger(PartitionTaskLogServiceImpl.class);

    @Override
    public boolean init(DboTaskRequest request, DboPartitionRuleData partitionRuleData) {
        if (partitionRuleData.getRuleData() != null) {
            ArrayList<PartitionTaskLogPO> logList = new ArrayList<PartitionTaskLogPO>();
            for (String ruleId : partitionRuleData.getRuleData().keySet()) {
                PartitionTaskLogPO log = new PartitionTaskLogPO();
                log.setAppId(request.getAppId());
                log.setBankId(request.getBankId());
                log.setJobNodeId(request.getJobNodeId());
                log.setJobRunId(request.getJobRunId());
                log.setTaskRunId(request.getTaskRunId());
                log.setPartitionRuleId(ruleId);
                logList.add(log);
            }
            if (this.saveBatch(logList)) {
                log.debug("task-run-id:[{}] job-run-id:[{}] \u521d\u59cb\u5316\u5206\u533asize:[{}]", new Object[]{request.getTaskRunId(), request.getJobRunId(), logList.size()});
                return true;
            }
        }
        return false;
    }

    @Override
    public PartitionTaskLogPO find(String jobRunId, String taskRunId, String ruleId) {
        return (PartitionTaskLogPO)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PartitionTaskLogPO::getJobRunId, (Object)jobRunId)).eq(PartitionTaskLogPO::getTaskRunId, (Object)taskRunId)).eq(PartitionTaskLogPO::getPartitionRuleId, (Object)ruleId));
    }

    @Override
    public boolean isAllSuccess(String jobRunId, String taskRunId) {
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PartitionTaskLogPO::getJobRunId, (Object)jobRunId)).eq(PartitionTaskLogPO::getTaskRunId, (Object)taskRunId));
        if (list == null || list.size() == 0) {
            return true;
        }
        for (PartitionTaskLogPO logPO : list) {
            if (StringUtils.equals((CharSequence)logPO.getTaskStatus(), (CharSequence)DboTaskResult.Success.name())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean updateStatus(Long logId, @NotNull TaskStatus status, String taskMessage) {
        return this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PartitionTaskLogPO::getLogId, (Object)logId)).set(PartitionTaskLogPO::getTaskStatus, (Object)status)).set(PartitionTaskLogPO::getTaskMessage, (Object)(taskMessage == null ? "" : DboTaskTool.cutIfTooLong(taskMessage, 255)))).set(status == TaskStatus.Running, PartitionTaskLogPO::getStartTime, (Object)new Date()).set(status != TaskStatus.Running, PartitionTaskLogPO::getEndTime, (Object)new Date()));
    }

    @Override
    public boolean updateStatus(String jobRunId, String taskRunId, String ruleId, @NotNull TaskStatus status, String taskMessage) {
        return this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PartitionTaskLogPO::getJobRunId, (Object)jobRunId)).eq(PartitionTaskLogPO::getTaskRunId, (Object)taskRunId)).eq(PartitionTaskLogPO::getPartitionRuleId, (Object)ruleId)).set(PartitionTaskLogPO::getTaskStatus, (Object)status)).set(PartitionTaskLogPO::getTaskMessage, (Object)(taskMessage == null ? "" : DboTaskTool.cutIfTooLong(taskMessage, 255)))).set(status == TaskStatus.Running, PartitionTaskLogPO::getStartTime, (Object)new Date()).set(status != TaskStatus.Running, PartitionTaskLogPO::getEndTime, (Object)new Date()));
    }

    @Override
    public boolean updateTaskRestart(String jobRunId, String taskRunId, String ruleId) {
        return this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PartitionTaskLogPO::getJobRunId, (Object)jobRunId)).eq(PartitionTaskLogPO::getTaskRunId, (Object)taskRunId)).eq(PartitionTaskLogPO::getPartitionRuleId, (Object)ruleId)).set(PartitionTaskLogPO::getTaskStatus, (Object)TaskStatus.Running.name())).set(PartitionTaskLogPO::getTaskMessage, (Object)""));
    }
}

