/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.checker;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResponse;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResult;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.shch.sfc.components.job.checker.DboTaskChecker;
import com.shch.sfc.components.job.ex.TaskPostCheckException;
import com.shch.sfc.components.job.ex.TaskPreCheckException;
import com.shch.sfc.components.job.po.TaskLogPO;
import com.shch.sfc.components.job.service.TaskLogService;
import com.shch.sfc.components.job.vo.DboTaskRequestWrap;
import com.shch.sfc.components.job.vo.PreCheckLogResult;
import com.shch.sfc.components.job.vo.PreCheckResult;
import com.shch.sfc.components.job.vo.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dboNormalTaskLogChecker")
public class DboNormalTaskLogChecker
implements DboTaskChecker {
    private static final Logger log = LoggerFactory.getLogger(DboNormalTaskLogChecker.class);
    @Autowired
    private TaskLogService taskLogService;

    @Override
    public PreCheckResult preCheck(DboTaskRequestWrap request) throws TaskPreCheckException {
        PreCheckLogResult result = new PreCheckLogResult();
        TaskLogPO taskLog = this.taskLogService.findTaskLog(request.getJobRunId(), request.getTaskRunId());
        Long taskLogId = null;
        if (taskLog != null) {
            if (StringUtils.equals((CharSequence)taskLog.getTaskStatus(), (CharSequence)TaskStatus.Success.name())) {
                result.setCheckSuccess(false);
                result.setTaskResult(DboTaskResult.Success, "\u5df2\u5b8c\u6210");
                return result;
            }
            if (StringUtils.equals((CharSequence)taskLog.getTaskStatus(), (CharSequence)TaskStatus.Running.name())) {
                result.setCheckSuccess(false);
                result.setTaskResult(DboTaskResult.Unknown, "\u8be5\u4efb\u52a1\u6b63\u5728\u8fd0\u884c");
                return result;
            }
            if (!this.taskLogService.updateTaskRestart(request.getJobRunId(), request.getTaskRunId())) {
                log.error("job-run-id:[{}] task-run-id:[{}] \u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3aRunning\u5931\u8d25", (Object)request.getJobRunId(), (Object)request.getTaskRunId());
                throw new TaskPreCheckException("\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3aRunning\u5931\u8d25");
            }
            taskLogId = taskLog.getLogId();
        } else {
            taskLogId = this.taskLogService.initIfNotExist(request);
        }
        if (taskLogId == null) {
            log.error("job-run-id:[{}] task-run-id:[{}] \u767b\u8bb0\u4efb\u52a1\u8bb0\u5f55\u5931\u8d25", (Object)request.getJobRunId(), (Object)request.getTaskRunId());
            throw new TaskPreCheckException("\u767b\u8bb0\u4efb\u52a1\u5931\u8d25");
        }
        result.setTaskLogId(taskLogId);
        result.setCheckSuccess(true);
        return result;
    }

    @Override
    public void postCheck(PreCheckResult checkResult, DboTaskRequestWrap request, DboTaskResponse response) throws TaskPostCheckException {
        PreCheckLogResult preCheckLogResult;
        if (checkResult instanceof PreCheckLogResult && (preCheckLogResult = (PreCheckLogResult)checkResult).getTaskLogId() != null && !this.taskLogService.updateTaskLog(preCheckLogResult.getTaskLogId(), request.getTaskName(), response)) {
            log.error("job-run-id:[{}] task-id:[{}] \u4efb\u52a1\u72b6\u6001[{}]\u66f4\u65b0\u5931\u8d25", new Object[]{request.getJobRunId(), request.getTaskId(), response.getTaskResult()});
            throw new TaskPostCheckException("\u4efb\u52a1\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
        }
    }
}

