/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.service.impl;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResponse;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.shch.sfc.components.job.mapper.TaskLogMapper;
import com.shch.sfc.components.job.po.TaskLogPO;
import com.shch.sfc.components.job.service.TaskLogService;
import com.shch.sfc.components.job.tools.DboTaskTool;
import com.shch.sfc.components.job.vo.DboTaskRequestWrap;
import com.shch.sfc.components.job.vo.TaskStatus;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service(value="taskLogService")
public class TaskLogServiceImpl
extends ServiceImpl<TaskLogMapper, TaskLogPO>
implements TaskLogService {
    private static final Logger logger = LoggerFactory.getLogger(TaskLogServiceImpl.class);

    @Override
    public Long initIfNotExist(DboTaskRequestWrap request) {
        TaskLogPO po = new TaskLogPO();
        po.setTaskId(request.getTaskId());
        po.setTaskRunId(request.getTaskRunId());
        po.setTaskStatus(TaskStatus.Running.name());
        po.setAppId(request.getAppId());
        po.setAppName(request.getAppName());
        po.setBankId(request.getBankId());
        po.setJobId(request.getJobId());
        po.setJobName(request.getJobName());
        po.setJobNodeId(request.getJobNodeId());
        po.setJobRunId(request.getJobRunId());
        po.setTaskType(request.getTaskType().name());
        po.setTaskName(request.getTaskName());
        po.setStartTime(new Date());
        try {
            if (this.save(po)) {
                return po.getLogId();
            }
            return null;
        }
        catch (DuplicateKeyException e) {
            logger.info("job-run-id:[{}] task-run-id:[{}] Exist.", (Object)request.getJobRunId(), (Object)request.getTaskRunId());
            return this.findLogId(request.getJobRunId(), request.getTaskRunId());
        }
    }

    public Long findLogId(String jobRunId, String taskRunId) {
        TaskLogPO logPO = (TaskLogPO)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{TaskLogPO::getLogId}).eq(TaskLogPO::getJobRunId, (Object)jobRunId)).eq(TaskLogPO::getTaskRunId, (Object)taskRunId));
        return logPO == null ? null : logPO.getLogId();
    }

    @Override
    public TaskLogPO findTaskLog(String jobRunId, String taskRunId) {
        return (TaskLogPO)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TaskLogPO::getJobRunId, (Object)jobRunId)).eq(TaskLogPO::getTaskRunId, (Object)taskRunId));
    }

    @Override
    public boolean updateTaskLog(Long logId, String taskName, DboTaskResponse response) {
        return this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TaskLogPO::getLogId, (Object)logId)).set(TaskLogPO::getEndTime, (Object)new Date())).set(TaskLogPO::getTaskStatus, (Object)TaskStatus.fromDboTaskResult(response.getTaskResult()).name())).set(TaskLogPO::getTaskMessage, (Object)(response.getTaskMessage() == null ? "" : DboTaskTool.cutIfTooLong(response.getTaskMessage(), 255)))).set(StringUtils.nonEmpty((CharSequence)taskName), TaskLogPO::getTaskName, (Object)taskName));
    }

    @Override
    public boolean updateTaskLog(String jobRunId, String taskRunId, String taskName, DboTaskResponse response) {
        return this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TaskLogPO::getJobRunId, (Object)jobRunId)).eq(TaskLogPO::getTaskRunId, (Object)taskRunId)).set(TaskLogPO::getEndTime, (Object)new Date())).set(TaskLogPO::getTaskStatus, (Object)TaskStatus.fromDboTaskResult(response.getTaskResult()).name())).set(TaskLogPO::getTaskMessage, (Object)(response.getTaskMessage() == null ? "" : DboTaskTool.cutIfTooLong(response.getTaskMessage(), 255)))).set(StringUtils.nonEmpty((CharSequence)taskName), TaskLogPO::getTaskName, (Object)taskName));
    }

    @Override
    public boolean isTaskSuccess(String jobRunId, String taskRunId) {
        TaskLogPO logPO = (TaskLogPO)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{TaskLogPO::getTaskStatus}).eq(TaskLogPO::getTaskStatus, (Object)TaskStatus.Success.name())).eq(TaskLogPO::getJobRunId, (Object)jobRunId)).eq(TaskLogPO::getTaskRunId, (Object)taskRunId));
        return logPO != null;
    }

    @Override
    public boolean updateTaskRestart(String jobRunId, String taskRunId) {
        return this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TaskLogPO::getJobRunId, (Object)jobRunId)).eq(TaskLogPO::getTaskRunId, (Object)taskRunId)).set(TaskLogPO::getTaskStatus, (Object)TaskStatus.Running.name())).set(TaskLogPO::getTaskMessage, (Object)""));
    }

    @Override
    public boolean saveOrUpdate(DboTaskRequestWrap request, DboTaskResponse response) {
        if (!this.updateTaskLog(request.getJobRunId(), request.getTaskRunId(), request.getTaskName(), response)) {
            TaskLogPO po = new TaskLogPO();
            po.setTaskId(request.getTaskId());
            po.setTaskRunId(request.getTaskRunId());
            po.setAppId(request.getAppId());
            po.setAppName(request.getAppName());
            po.setBankId(request.getBankId());
            po.setJobId(request.getJobId());
            po.setJobName(request.getJobName());
            po.setJobNodeId(request.getJobNodeId());
            po.setJobRunId(request.getJobRunId());
            po.setTaskType(request.getTaskType().name());
            po.setTaskName(request.getTaskName());
            po.setStartTime(new Date());
            if (response != null) {
                po.setEndTime(new Date());
                po.setTaskStatus(TaskStatus.fromDboTaskResult(response.getTaskResult()).name());
                po.setTaskMessage(response.getTaskMessage() == null ? "" : DboTaskTool.cutIfTooLong(response.getTaskMessage(), 255));
                return this.save(po);
            }
        }
        return true;
    }
}

