/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.checker;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResponse;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResult;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.shch.sfc.components.job.checker.DboTaskChecker;
import com.shch.sfc.components.job.ex.TaskPostCheckException;
import com.shch.sfc.components.job.ex.TaskPreCheckException;
import com.shch.sfc.components.job.po.PartitionTaskLogPO;
import com.shch.sfc.components.job.po.TaskLogPO;
import com.shch.sfc.components.job.service.PartitionTaskLogService;
import com.shch.sfc.components.job.service.TaskLogService;
import com.shch.sfc.components.job.vo.DboTaskRequestWrap;
import com.shch.sfc.components.job.vo.PreCheckLogResult;
import com.shch.sfc.components.job.vo.PreCheckResult;
import com.shch.sfc.components.job.vo.TaskStatus;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="dboPartitionTaskLogChecker")
public class DboPartitionTaskLogChecker
implements DboTaskChecker {
    private static final Logger log = LoggerFactory.getLogger(DboPartitionTaskLogChecker.class);
    @Autowired
    private TaskLogService taskLogService;
    @Autowired
    private PartitionTaskLogService partitionTaskLogService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PreCheckResult preCheck(DboTaskRequestWrap request) throws TaskPreCheckException {
        PreCheckLogResult result = new PreCheckLogResult();
        PartitionTaskLogPO partitionLog = this.partitionTaskLogService.find(request.getJobRunId(), request.getTaskRunId(), request.getPartitionRuleId());
        if (partitionLog != null) {
            if (StringUtils.isEmpty((CharSequence)partitionLog.getTaskStatus())) {
                if (!this.partitionTaskLogService.updateStatus(request.getJobRunId(), request.getTaskRunId(), request.getPartitionRuleId(), TaskStatus.Running, null)) {
                    log.error("job-run-id:[{}] task-run-id:[{}] partition-rule-id:[{}] \u4fee\u6539\u72b6\u6001[{}]\u5931\u8d25", new Object[]{request.getJobRunId(), request.getTaskRunId(), request.getPartitionRuleId(), TaskStatus.Running});
                    throw new TaskPreCheckException("[" + request.getPartitionRuleId() + "]\u4fee\u6539\u8fd0\u884c\u4e2d\u72b6\u6001\u5931\u8d25");
                }
            } else {
                if (StringUtils.equals((CharSequence)partitionLog.getTaskStatus(), (CharSequence)TaskStatus.Success.name())) {
                    result.setCheckSuccess(false);
                    result.setTaskResult(DboTaskResult.Success, "\u5df2\u5b8c\u6210");
                    return result;
                }
                if (StringUtils.equals((CharSequence)partitionLog.getTaskStatus(), (CharSequence)TaskStatus.Running.name())) {
                    result.setCheckSuccess(false);
                    result.setTaskResult(DboTaskResult.Unknown, "\u8be5\u4efb\u52a1\u6b63\u5728\u8fd0\u884c");
                    return result;
                }
                if (!this.partitionTaskLogService.updateTaskRestart(request.getJobRunId(), request.getTaskRunId(), request.getPartitionRuleId())) {
                    log.error("job-run-id:[{}] task-run-id:[{}] partition-rule-id:[{}] \u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3aRunning\u5931\u8d25", new Object[]{request.getJobRunId(), request.getTaskRunId(), request.getPartitionRuleId()});
                    throw new TaskPreCheckException("\u66f4\u65b0\u5206\u533a\u4efb\u52a1\u72b6\u6001\u4e3aRunning\u5931\u8d25");
                }
            }
        } else {
            log.error("job-run-id:[{}] task-run-id:[{}] partition-rule-id:[{}] \u672a\u627e\u5230\u5206\u7247\u72b6\u6001\u8bb0\u5f55\uff0c\u5206\u7247\u89c4\u5219Task\u9700\u8981\u7ee7\u627fAbstractDboPartitionRuleLogTask", new Object[]{request.getJobRunId(), request.getTaskRunId(), request.getPartitionRuleId()});
            throw new TaskPreCheckException("\u672a\u627e\u5230\u5206\u7247\u72b6\u6001\u8bb0\u5f55\uff0c\u5206\u7247RULE_ID:" + request.getPartitionRuleId());
        }
        Long mainTaskLogId = null;
        TaskLogPO mainLog = this.taskLogService.findTaskLog(request.getJobRunId(), request.getTaskRunId());
        if (mainLog == null) {
            mainTaskLogId = this.taskLogService.initIfNotExist(request);
            if (mainTaskLogId == null) {
                log.error("job-run-id:[{}] task-run-id:[{}] partition-rule-id:[{}] \u767b\u8bb0\u4e3b\u4efb\u52a1\u5931\u8d25", new Object[]{request.getJobRunId(), request.getTaskRunId(), request.getPartitionRuleId()});
                throw new TaskPreCheckException("[" + request.getPartitionRuleId() + "]\u767b\u8bb0\u4e3b\u4efb\u52a1\u5931\u8d25");
            }
        } else {
            if (!this.taskLogService.updateTaskRestart(request.getJobRunId(), request.getTaskRunId())) {
                log.error("job-run-id:[{}] task-run-id:[{}] \u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3aRunning\u5931\u8d25", (Object)request.getJobRunId(), (Object)request.getTaskRunId());
                throw new TaskPreCheckException("\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3aRunning\u5931\u8d25");
            }
            mainTaskLogId = mainLog.getLogId();
        }
        result.setPartitionTaskLogId(partitionLog.getLogId());
        result.setTaskLogId(mainTaskLogId);
        result.setCheckSuccess(true);
        return result;
    }

    @Override
    public void postCheck(PreCheckResult checkResult, DboTaskRequestWrap request, DboTaskResponse response) throws TaskPostCheckException {
        PreCheckLogResult preCheckLogResult;
        if (checkResult instanceof PreCheckLogResult && (preCheckLogResult = (PreCheckLogResult)checkResult).getPartitionTaskLogId() != null && preCheckLogResult.getTaskLogId() != null) {
            if (!this.partitionTaskLogService.updateStatus(preCheckLogResult.getPartitionTaskLogId(), TaskStatus.fromDboTaskResult(response.getTaskResult()), response.getTaskMessage())) {
                log.error("job-run-id:[{}] task-run-id:[{}] partition-rule-id:[{}] \u5206\u533a\u4efb\u52a1\u72b6\u6001[{}]\u66f4\u65b0\u5931\u8d25", new Object[]{request.getJobRunId(), request.getTaskRunId(), request.getPartitionRuleId(), response.getTaskResult()});
                throw new TaskPostCheckException("\u5206\u533a\u4efb\u52a1\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
            boolean needUpdateMainTask = false;
            if (Objects.equals(response.getTaskResult(), DboTaskResult.Success)) {
                if (this.partitionTaskLogService.isAllSuccess(request.getJobRunId(), request.getTaskRunId())) {
                    needUpdateMainTask = true;
                }
            } else {
                needUpdateMainTask = true;
                response.setTaskMessage("[" + request.getTaskName() + "]" + response.getTaskMessage());
            }
            if (needUpdateMainTask && !this.taskLogService.updateTaskLog(preCheckLogResult.getTaskLogId(), request.getTaskName(), response)) {
                log.error("job-run-id:[{}] task-run-id:[{}] \u4e3b\u4efb\u52a1\u72b6\u6001[{}]\u66f4\u65b0\u5931\u8d25 ", new Object[]{request.getJobRunId(), request.getTaskRunId(), response.getTaskResult()});
                throw new TaskPostCheckException("\u4e3b\u4efb\u52a1\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
        }
    }
}

