/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.BillTemplate;
import cn.com.yusys.yusp.commons.excelcsv.CsvTemplate;
import cn.com.yusys.yusp.commons.excelcsv.ExcelTemplate;
import cn.com.yusys.yusp.commons.excelcsv.ITemplate;
import cn.com.yusys.yusp.commons.excelcsv.XmlTemplate;
import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.file.api.FileInfo;
import cn.com.yusys.yusp.commons.file.util.FileInfoUtils;
import com.shch.sfc.components.excelcsv.AbstractEfDataHandle;
import com.shch.sfc.components.excelcsv.TemplateManager;
import com.shch.sfc.core.context.SfcContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExporterImporter {
    private static final Logger log = LoggerFactory.getLogger(ExporterImporter.class);
    public static final List<String> FILE_TYPE_LIST = Collections.unmodifiableList(Arrays.asList("csv", "xls", "xlsx"));
    private int sheetMaxRow;
    private final Map<String, ITemplate> templateMap = new ConcurrentHashMap<String, ITemplate>();

    public ExporterImporter() {
    }

    public ExporterImporter(int sheetMaxRow) {
        this.sheetMaxRow = sheetMaxRow;
    }

    public File export(Class<?> headClass, Object model) {
        return this.export(headClass, model, new AbstractEfDataHandle.DefaultDataHandle());
    }

    public File export(Class<?> headClass, Object model, AbstractEfDataHandle dataHandle) {
        return this.simpleExport(headClass, model, dataHandle, this.checkFileTypeInContext(true));
    }

    private File simpleExport(Class<?> headClass, Object model, AbstractEfDataHandle dataHandle, String fileType) {
        Objects.requireNonNull(headClass, "headClass can not be null.");
        Objects.requireNonNull(model, "model can not be null.");
        Objects.requireNonNull(dataHandle, "dataHandle can not be null.");
        try {
            CsvTemplate iTemplate;
            File outFile = this.getOutFile(fileType);
            if ("csv".equals(fileType)) {
                log.info("export csv file.");
                iTemplate = new CsvTemplate(headClass, (DataHandle)dataHandle);
            } else {
                log.info("export excel file.");
                iTemplate = new ExcelTemplate(headClass, this.sheetMaxRow, (DataHandle)dataHandle);
            }
            iTemplate.export(model, outFile);
            return outFile;
        }
        catch (Exception e) {
            throw new IllegalStateException("export failed.", e);
        }
    }

    public File export(Object model) {
        return this.export(this.checkFileTypeInContext(false), model);
    }

    public File export(String templateName, Object model) {
        return this.billExport(templateName, model);
    }

    public File export(File templateFile, Object model) {
        try {
            File outFile = this.getTmpOutFile(templateFile.getName());
            ITemplate iTemplate = this.templateMap.computeIfAbsent(templateFile.getName(), tName -> {
                if (tName.endsWith(".ftl")) {
                    return new XmlTemplate(templateFile, (DataHandle)new AbstractEfDataHandle.DefaultDataHandle());
                }
                return new BillTemplate(templateFile, (DataHandle)new AbstractEfDataHandle.DefaultDataHandle());
            });
            iTemplate.export(model, outFile);
            return outFile;
        }
        catch (Exception e) {
            throw new IllegalStateException("export bill failed.", e);
        }
    }

    private File billExport(String templateName, Object model) {
        try {
            File outFile = this.getTmpOutFile(templateName);
            ITemplate iTemplate = this.templateMap.computeIfAbsent(templateName, tName -> TemplateManager.getInstance().readTemplate(templateName));
            iTemplate.export(model, outFile);
            return outFile;
        }
        catch (Exception e) {
            throw new IllegalStateException("export bill failed.", e);
        }
    }

    private File getTmpOutFile(String templateName) throws IOException {
        String fileExtName = templateName.substring(templateName.lastIndexOf(".") + 1);
        return this.getOutFile("ftl".equalsIgnoreCase(fileExtName) ? "xml" : fileExtName);
    }

    public <T> List<T> importData(Class<T> headClass, File inFile) {
        ArrayList importList = new ArrayList();
        this.importData(headClass, inFile, rowData -> {
            if (rowData.getClass() == headClass) {
                importList.add(rowData);
            } else {
                log.warn("the row data is not the type {}", (Object)headClass.getName());
            }
        });
        return importList;
    }

    public void importData(Class<?> headClass, File inFile, Consumer<Object> handleFun) {
        this.importData(headClass, inFile, new AbstractEfDataHandle.DefaultDataHandle(), handleFun);
    }

    public void importData(Class<?> headClass, File inFile, AbstractEfDataHandle dataHandle, Consumer<Object> handleFun) {
        block4: {
            Objects.requireNonNull(headClass, "headClass can not be null.");
            Objects.requireNonNull(inFile, "file can not be null.");
            Objects.requireNonNull(dataHandle, "dataHandle can not be null.");
            Objects.requireNonNull(handleFun, "handleFun can not be null.");
            try {
                String fileName = inFile.getName().toLowerCase();
                if (fileName.endsWith(".csv")) {
                    CsvTemplate csvTemplate = new CsvTemplate(headClass, (DataHandle)dataHandle);
                    csvTemplate.importData(inFile, handleFun);
                    break block4;
                }
                if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) {
                    ExcelTemplate excelTemplate = new ExcelTemplate(headClass, 1000, (DataHandle)dataHandle);
                    excelTemplate.importData(inFile, handleFun);
                    break block4;
                }
                throw new IllegalArgumentException("the file type " + fileName + " is not supported.");
            }
            catch (Exception e) {
                throw new IllegalStateException("import error.", e);
            }
        }
    }

    private String checkFileTypeInContext(boolean isSimple) {
        String exportFlag = SfcContext.get().getExportFlag();
        if (exportFlag == null) {
            throw new IllegalStateException("the export flag in context is null.");
        }
        if (isSimple && !FILE_TYPE_LIST.contains(exportFlag)) {
            throw new IllegalStateException("must specify an explicit export type [xls/xlsx/csv] in context");
        }
        if (!isSimple && FILE_TYPE_LIST.contains(exportFlag)) {
            throw new IllegalStateException("must specify an explicit template name in context or you can manually specify the template name");
        }
        return exportFlag;
    }

    public static FileInfo uploadTmpFile(File tempFile) {
        return FileInfoUtils.uploadTempFile((File)tempFile);
    }

    private File getOutFile(String fileType) throws IOException {
        return File.createTempFile("shch-export-", "." + fileType);
    }
}

