/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.task;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskRequest;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResponse;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResult;
import cn.com.yusys.yusp.commons.util.BooleanUtils;
import com.shch.sfc.components.job.checker.DboCheckManager;
import com.shch.sfc.components.job.checker.DboTaskChecker;
import com.shch.sfc.components.job.task.AbstractDboRemoteStateSyncTask;
import com.shch.sfc.components.job.tools.DboTaskTool;
import com.shch.sfc.components.job.vo.DboCheckResultInfo;
import com.shch.sfc.components.job.vo.DboTaskRequestWrap;
import com.shch.sfc.components.job.vo.PreCheckResult;
import com.shch.sfc.components.job.vo.TaskResponse;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDboCheckTask
extends AbstractDboRemoteStateSyncTask {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDboCheckTask.class);
    @Autowired
    private DboCheckManager dboCheckManager;

    protected abstract void AssembleTaskChecker(List<DboTaskChecker> var1, DboTaskRequest var2);

    protected DboTaskResponse onPreCheckFailed(PreCheckResult checkResult) {
        return checkResult.getTaskResponse();
    }

    protected boolean isPreCheckRollbackAll() {
        return false;
    }

    @Override
    protected DboTaskResponse executeTask(DboTaskRequestWrap requestWrap) {
        List<DboCheckResultInfo> resultInfoList = null;
        DboTaskResponse response = null;
        try {
            ArrayList<DboTaskChecker> checkerList = new ArrayList<DboTaskChecker>();
            this.AssembleTaskChecker(checkerList, requestWrap);
            if (checkerList.size() > 0) {
                if (this.isPreCheckRollbackAll()) {
                    resultInfoList = this.dboCheckManager.preCheckForRollbackAll(checkerList, requestWrap);
                } else {
                    resultInfoList = new ArrayList<DboCheckResultInfo>();
                    this.dboCheckManager.preCheck(checkerList, requestWrap, resultInfoList);
                }
                for (DboCheckResultInfo resultInfo : resultInfoList) {
                    PreCheckResult checkResult = resultInfo.getPreCheckResult();
                    if (!BooleanUtils.isFalse((Boolean)checkResult.getCheckSuccess())) continue;
                    response = this.onPreCheckFailed(checkResult);
                    break;
                }
            }
            if (response == null) {
                TaskResponse taskResponse = this.onExecute(resultInfoList, requestWrap);
                if (taskResponse == null) {
                    logger.error("job-run-id:[{}] task-run-id:[{}] \u4e1a\u52a1\u6267\u884c\u8fd4\u56denull", (Object)requestWrap.getJobRunId(), (Object)requestWrap.getTaskRunId());
                    response = new DboTaskResponse();
                    response.setTaskResult(DboTaskResult.Unknown, "\u4e1a\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3anull");
                } else {
                    response = DboTaskTool.toDboTaskResponse(taskResponse);
                }
            }
        }
        catch (Exception e) {
            logger.error("job-run-id:[{}] task-run-id:[{}] Exception", new Object[]{requestWrap.getJobRunId(), requestWrap.getTaskRunId(), e});
            response = DboTaskTool.withException(e);
        }
        if (resultInfoList != null) {
            response = this.dboCheckManager.postCheck(resultInfoList, requestWrap, response);
        }
        return response;
    }

    protected TaskResponse onExecute(List<DboCheckResultInfo> resultInfoList, DboTaskRequestWrap dboTaskRequest) throws Exception {
        return this.onExecute(dboTaskRequest);
    }

    protected abstract TaskResponse onExecute(DboTaskRequestWrap var1) throws Exception;
}

