/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.checker;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResponse;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResult;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.shch.sfc.components.job.checker.DboPartitionTaskLogChecker;
import com.shch.sfc.components.job.checker.DboTaskChecker;
import com.shch.sfc.components.job.ex.TaskPreCheckException;
import com.shch.sfc.components.job.vo.DboCheckResultInfo;
import com.shch.sfc.components.job.vo.DboTaskRequestWrap;
import com.shch.sfc.components.job.vo.PreCheckResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="dboCheckManager")
public class DboCheckManager {
    @Transactional(rollbackFor={Exception.class})
    public List<DboCheckResultInfo> preCheckForRollbackAll(List<DboTaskChecker> list, DboTaskRequestWrap request) throws TaskPreCheckException {
        ArrayList<DboCheckResultInfo> resultInfoList = new ArrayList<DboCheckResultInfo>();
        for (DboTaskChecker checker : list) {
            PreCheckResult result = checker.preCheck(request);
            resultInfoList.add(new DboCheckResultInfo(checker, result));
            if (result.getCheckSuccess().booleanValue()) continue;
            if (result.getTaskResponse() != null && Objects.equals(result.getTaskResponse().getTaskResult(), DboTaskResult.Success)) break;
            throw new TaskPreCheckException(result.getTaskResponse() == null ? "\u524d\u7f6e\u68c0\u67e5\u5f02\u5e38:" + checker.getClass().getName() : result.getTaskResponse().getTaskMessage());
        }
        return resultInfoList;
    }

    public void preCheck(List<DboTaskChecker> list, DboTaskRequestWrap request, List<DboCheckResultInfo> resultInfoList) throws TaskPreCheckException {
        for (DboTaskChecker checker : list) {
            PreCheckResult result = checker.preCheck(request);
            resultInfoList.add(new DboCheckResultInfo(checker, result));
            if (result.getCheckSuccess().booleanValue()) continue;
            break;
        }
    }

    public DboTaskResponse postCheck(List<DboCheckResultInfo> list, DboTaskRequestWrap request, DboTaskResponse response) {
        if (list != null) {
            DboCheckResultInfo partitionTaskCheckResultInfo = null;
            for (DboCheckResultInfo resultInfo : list) {
                if (!(resultInfo.getTaskChecker() instanceof DboPartitionTaskLogChecker)) continue;
                partitionTaskCheckResultInfo = resultInfo;
                break;
            }
            if (partitionTaskCheckResultInfo != null) {
                list.add(partitionTaskCheckResultInfo);
            }
            Collections.reverse(list);
            boolean isCheckPostFailed = false;
            boolean partitionTaskChecked = false;
            for (DboCheckResultInfo resultInfo : list) {
                if (resultInfo.getTaskChecker() == null) continue;
                if (resultInfo == partitionTaskCheckResultInfo) {
                    if (!partitionTaskChecked) {
                        partitionTaskChecked = true;
                    } else if (!isCheckPostFailed) continue;
                }
                try {
                    resultInfo.getTaskChecker().postCheck(resultInfo.getPreCheckResult(), request, response);
                }
                catch (Exception e) {
                    isCheckPostFailed = true;
                    if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
                        response.setTaskResult(DboTaskResult.Exception, e.getClass().getName());
                        continue;
                    }
                    response.setTaskResult(DboTaskResult.Exception, e.getMessage());
                }
            }
        }
        return response;
    }
}

