/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.task;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskRequest;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResponse;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResult;
import cn.com.yusys.yusp.batch.dbo.taskcenter.spring.task.SpringDboTask;
import com.shch.sfc.components.job.tools.DboTaskTool;
import com.shch.sfc.components.job.vo.DboTaskRequestWrap;
import com.shch.sfc.components.job.vo.TaskResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDboSampleTask
implements SpringDboTask {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDboSampleTask.class);

    public DboTaskResponse execute(DboTaskRequest dboTaskRequest) {
        DboTaskRequestWrap request = new DboTaskRequestWrap(dboTaskRequest);
        DboTaskResponse response = null;
        try {
            response = this.onStart(request);
        }
        catch (Exception e) {
            response = DboTaskTool.withException(e);
        }
        if (response != null) {
            return response;
        }
        try {
            TaskResponse taskResponse = this.onExecute(request);
            if (taskResponse == null) {
                logger.error("job-run-id:[{}] task-run-id:[{}] \u4e1a\u52a1\u6267\u884c\u8fd4\u56denull", (Object)request.getJobRunId(), (Object)request.getTaskRunId());
                response = new DboTaskResponse();
                response.setTaskResult(DboTaskResult.Unknown, "\u4e1a\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3anull");
            } else {
                response = DboTaskTool.toDboTaskResponse(taskResponse);
            }
        }
        catch (Exception e) {
            logger.error("job-run-id:[{}] task-run-id:[{}] Exception", new Object[]{request.getJobRunId(), request.getTaskRunId(), e});
            response = DboTaskTool.withException(e);
        }
        try {
            response = this.onFinish(request, response);
        }
        catch (Exception e) {
            logger.error("job-run-id:[{}] task-run-id:[{}] postCheck onFinish\u5904\u7406\u5f02\u5e38\uff1a", new Object[]{request.getJobRunId(), request.getTaskRunId(), e});
        }
        return response;
    }

    protected DboTaskResponse onStart(DboTaskRequestWrap request) {
        return null;
    }

    protected DboTaskResponse onFinish(DboTaskRequestWrap request, DboTaskResponse response) {
        return response;
    }

    protected abstract TaskResponse onExecute(DboTaskRequestWrap var1) throws Exception;
}

