/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.checker;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResponse;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResult;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskType;
import com.shch.sfc.components.job.checker.DboTaskChecker;
import com.shch.sfc.components.job.ex.TaskPostCheckException;
import com.shch.sfc.components.job.ex.TaskPreCheckException;
import com.shch.sfc.components.job.service.PartitionTaskLogService;
import com.shch.sfc.components.job.service.TaskLogService;
import com.shch.sfc.components.job.vo.DboTaskRequestWrap;
import com.shch.sfc.components.job.vo.PreCheckResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dboPartitionRuleTaskLogChecker")
public class DboPartitionRuleTaskLogChecker
implements DboTaskChecker {
    private static final Logger log = LoggerFactory.getLogger(DboPartitionRuleTaskLogChecker.class);
    @Autowired
    private PartitionTaskLogService partitionTaskLogService;
    @Autowired
    private TaskLogService taskLogService;

    @Override
    public PreCheckResult preCheck(DboTaskRequestWrap request) throws TaskPreCheckException {
        PreCheckResult result = new PreCheckResult();
        if (request.getTaskType() != DboTaskType.DataPartition) {
            result.setCheckSuccess(false);
            result.setTaskResult(DboTaskResult.Failed, "\u5f53\u524dTaskType\u4e0d\u662fDataPartition");
        } else {
            result.setCheckSuccess(true);
        }
        return result;
    }

    @Override
    public void postCheck(PreCheckResult checkResult, DboTaskRequestWrap request, DboTaskResponse response) throws TaskPostCheckException {
        if (response.getTaskResult() == DboTaskResult.Success && response.getPartitionRuleData() != null && !response.getPartitionRuleData().isEmpty()) {
            if (!this.partitionTaskLogService.init(request, response.getPartitionRuleData())) {
                log.error("job-run-id:[{}] task-run-id:[{}] \u5728\u5206\u533a\u89c4\u5219\u4e2d\u521d\u59cb\u5316\u5206\u533aTaskLog\u5931\u8d25", (Object)request.getJobRunId(), (Object)request.getTaskRunId());
                response.setTaskResult(DboTaskResult.Failed, "[\u5206\u533a\u89c4\u5219]\u521d\u59cb\u5316\u5206\u533aTaskLog\u5931\u8d25\uff0c\u66f4\u65b0TaskLog\u5931\u8d25");
                if (!this.taskLogService.saveOrUpdate(request, response)) {
                    log.error("job-run-id:[{}] task-run-id:[{}] response:[{}] msg:[{}]\u5728\u5206\u533a\u89c4\u5219\u4e2d\u66f4\u65b0TaskLog\u5931\u8d25", new Object[]{request.getJobRunId(), request.getTaskRunId(), response.getTaskResult(), response.getTaskMessage()});
                    throw new TaskPostCheckException("[\u5206\u533a\u89c4\u5219]\u521d\u59cb\u5316\u5206\u533aLOG\u5931\u8d25\uff0c\u66f4\u65b0TaskLog\u72b6\u6001\u5931\u8d25");
                }
                throw new TaskPostCheckException("[\u5206\u533a\u89c4\u5219]\u521d\u59cb\u5316\u5206\u533aTaskLog\u5931\u8d25");
            }
            return;
        }
        if (!this.taskLogService.saveOrUpdate(request, response)) {
            log.error("job-run-id:[{}] task-run-id:[{}] response:[{}] msg:[{}]\u5728\u5206\u533a\u89c4\u5219\u4e2d\u66f4\u65b0TaskLog\u72b6\u6001\u5931\u8d25", new Object[]{request.getJobRunId(), request.getTaskRunId(), response.getTaskResult(), response.getTaskMessage()});
            throw new TaskPostCheckException("[\u5206\u533a\u89c4\u5219]\u66f4\u65b0TaskLog\u72b6\u6001\u5931\u8d25");
        }
    }
}

