/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.tools;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskRequest;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResponse;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResult;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskType;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.shch.sfc.components.job.vo.TaskResponse;
import java.util.Calendar;
import java.util.Date;
import javax.validation.constraints.NotNull;

public class DboTaskTool {
    public static DboTaskResponse withException(Exception e) {
        DboTaskResponse response = new DboTaskResponse();
        if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
            response.setTaskResult(DboTaskResult.Exception, e.getClass().getName());
        } else {
            response.setTaskResult(DboTaskResult.Exception, e.getMessage());
        }
        return response;
    }

    public static DboTaskResponse toDboTaskResponse(@NotNull TaskResponse taskResponse) {
        DboTaskResponse response = new DboTaskResponse();
        if (taskResponse.getCode().equals(TaskResponse.Code_Ok)) {
            response.setTaskResult(DboTaskResult.Success, taskResponse.getTaskMessage());
        } else {
            response.setTaskResult(DboTaskResult.Failed, taskResponse.getTaskMessage());
        }
        response.setTaskOutputParas(taskResponse.getTaskOutputParas());
        response.setPartitionRuleData(taskResponse.getPartitionRuleData());
        return response;
    }

    public static int compareDay(Date date1, Date date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        int year1 = calendar1.get(1);
        int year2 = calendar2.get(1);
        if (year1 > year2) {
            return 1;
        }
        if (year1 < year2) {
            return -1;
        }
        int day1 = calendar1.get(6);
        int day2 = calendar2.get(6);
        return Integer.compare(day1, day2);
    }

    public static String getTaskId(DboTaskRequest request) {
        if (request.getTaskType() == DboTaskType.PartitionTask) {
            return request.getTaskParentRunId().substring(request.getAppId().length() + 1);
        }
        return request.getTaskId();
    }

    public static String getPartitionRuleId(DboTaskRequest request) {
        if (request.getTaskType() == DboTaskType.PartitionTask) {
            return request.getTaskId();
        }
        return null;
    }

    public static String getTaskRunIdWithoutRuleId(DboTaskRequest request) {
        if (request.getTaskType() == DboTaskType.PartitionTask) {
            return request.getTaskParentRunId();
        }
        return request.getTaskRunId();
    }

    public static String cutIfTooLong(String taskMessage, int maxBytes) {
        String msg = taskMessage;
        if (msg != null && msg.getBytes().length > maxBytes) {
            msg = msg.length() == msg.getBytes().length ? msg.substring(0, maxBytes) : msg.substring(0, maxBytes / 3);
        }
        return msg;
    }
}

