/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.task;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResponse;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResult;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskType;
import com.shch.sfc.components.job.service.PartitionTaskLogService;
import com.shch.sfc.components.job.task.AbstractDboSampleTask;
import com.shch.sfc.components.job.tools.DboTaskTool;
import com.shch.sfc.components.job.vo.DboTaskRequestWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDboPartitionDataLogTask
extends AbstractDboSampleTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractDboPartitionDataLogTask.class);
    @Autowired
    private PartitionTaskLogService partitionTaskLogService;

    @Override
    protected DboTaskResponse onStart(DboTaskRequestWrap request) {
        if (request.getTaskType() != DboTaskType.DataPartition) {
            DboTaskResponse response = new DboTaskResponse();
            response.setTaskResult(DboTaskResult.Failed, "\u5f53\u524dTaskType\u4e0d\u662fDataPartition");
            return response;
        }
        return null;
    }

    @Override
    protected DboTaskResponse onFinish(DboTaskRequestWrap request, DboTaskResponse response) {
        if (response.getTaskResult() == DboTaskResult.Success) {
            try {
                if (!this.partitionTaskLogService.init(request, response.getPartitionRuleData())) {
                    log.error("job-run-id:[{}] task-run-id:[{}] \u521d\u59cb\u5316\u5206\u533aLOG\u5931\u8d25", (Object)request.getJobRunId(), (Object)request.getTaskRunId());
                    response.setTaskResult(DboTaskResult.Failed, "\u521d\u59cb\u5316\u5206\u533aLOG\u5931\u8d25");
                }
            }
            catch (Exception e) {
                log.error("job-run-id:[{}] task-run-id:[{}] \u521d\u59cb\u5316\u5206\u533aLOG\u5f02\u5e38:", new Object[]{request.getJobRunId(), request.getTaskRunId(), e});
                return DboTaskTool.withException(e);
            }
        }
        return response;
    }
}

