/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.task;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskRequest;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResponse;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResult;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskType;
import cn.com.yusys.yusp.batch.dbo.taskcenter.spring.task.SpringDboTask;
import cn.com.yusys.yusp.commons.util.BooleanUtils;
import com.shch.sfc.components.job.checker.DboTaskChecker;
import com.shch.sfc.components.job.ex.TaskPostCheckException;
import com.shch.sfc.components.job.ex.TaskPreCheckException;
import com.shch.sfc.components.job.tools.DboTaskTool;
import com.shch.sfc.components.job.vo.DboTaskRequestWrap;
import com.shch.sfc.components.job.vo.PreCheckResult;
import com.shch.sfc.components.job.vo.TaskResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractDboLogTask
implements SpringDboTask {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDboLogTask.class);
    @Autowired
    @Qualifier(value="dboNormalTaskLogChecker")
    private DboTaskChecker dboNormalTaskLogChecker;
    @Autowired
    @Qualifier(value="dboPartitionTaskLogChecker")
    private DboTaskChecker dboPartitionTaskLogChecker;

    private DboTaskChecker getDboTaskChecker(DboTaskRequest request) {
        if (request.getTaskType() == DboTaskType.PartitionTask) {
            return this.dboPartitionTaskLogChecker;
        }
        return this.dboNormalTaskLogChecker;
    }

    protected PreCheckResult preCheck(PreCheckResult preCheckResult, DboTaskRequestWrap request) throws TaskPreCheckException {
        return this.getDboTaskChecker(request).preCheck(preCheckResult, request);
    }

    protected void postCheck(PreCheckResult checkResult, DboTaskRequestWrap request, DboTaskResponse response) throws TaskPostCheckException {
        this.getDboTaskChecker(request).postCheck(checkResult, request, response);
    }

    public DboTaskResponse execute(DboTaskRequest dboTaskRequest) {
        DboTaskResponse response;
        DboTaskRequestWrap request = new DboTaskRequestWrap(dboTaskRequest);
        PreCheckResult checkResult = null;
        try {
            checkResult = this.preCheck(null, request);
            if (BooleanUtils.isFalse((Boolean)checkResult.getCheckSuccess())) {
                response = new DboTaskResponse();
                response.setTaskResult(checkResult.getTaskResult(), checkResult.getTaskMessage());
                logger.warn("job-run-id:[{}] task-run-id:[{}] preCheck failed, checkResult:[{}]", new Object[]{request.getJobRunId(), request.getTaskRunId(), checkResult});
            } else {
                TaskResponse taskResponse = this.onExecute(checkResult, request);
                if (taskResponse == null) {
                    logger.error("job-run-id:[{}] task-run-id:[{}] \u4e1a\u52a1\u6267\u884c\u8fd4\u56denull", (Object)request.getJobRunId(), (Object)request.getTaskRunId());
                    response = new DboTaskResponse();
                    response.setTaskResult(DboTaskResult.Unknown, "\u4e1a\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3anull");
                } else {
                    response = DboTaskTool.toDboTaskResponse(taskResponse);
                }
            }
        }
        catch (Exception e) {
            logger.error("job-run-id:[{}] task-run-id:[{}] Exception", new Object[]{request.getJobRunId(), request.getTaskRunId(), e});
            response = DboTaskTool.withException(e);
        }
        try {
            this.postCheck(checkResult, request, response);
        }
        catch (Exception e) {
            logger.error("job-run-id:[{}] task-run-id:[{}] postCheck \u540e\u7f6e\u5904\u7406\u5f02\u5e38\uff1a", new Object[]{request.getJobRunId(), request.getTaskRunId(), e});
        }
        return response;
    }

    protected TaskResponse onExecute(PreCheckResult checkResult, DboTaskRequestWrap dboTaskRequest) throws Exception {
        return this.onExecute(dboTaskRequest);
    }

    protected abstract TaskResponse onExecute(DboTaskRequestWrap var1) throws Exception;
}

