/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.job.checker;

import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskRequest;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResponse;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskResult;
import cn.com.yusys.yusp.batch.dbo.task.api.context.DboTaskType;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import com.shch.sfc.components.job.checker.DboTaskChecker;
import com.shch.sfc.components.job.ex.TaskPostCheckException;
import com.shch.sfc.components.job.ex.TaskPreCheckException;
import com.shch.sfc.components.job.po.TaskDayPO;
import com.shch.sfc.components.job.service.TaskDayService;
import com.shch.sfc.components.job.service.TaskLogService;
import com.shch.sfc.components.job.tools.DboTaskTool;
import com.shch.sfc.components.job.vo.DboTaskRequestWrap;
import com.shch.sfc.components.job.vo.PreCheckBizDayResult;
import com.shch.sfc.components.job.vo.PreCheckResult;
import com.shch.sfc.components.job.vo.TaskDayUpdateStatus;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dboBizCalendarTaskChecker")
public class DboBizCalendarTaskChecker
implements DboTaskChecker {
    private static final Logger log = LoggerFactory.getLogger(DboBizCalendarTaskChecker.class);
    @Autowired
    private TaskDayService taskDayService;
    @Autowired
    private TaskLogService taskLogService;

    private Date getBizDay(DboTaskRequest request) {
        if (request.getJobParameters() == null) {
            log.error("-------request.getJobParameters() == null-------");
            return null;
        }
        String bizDay = request.getJobParameters().getParameter("BusinessDate");
        log.info("get bizDay from BusinessDate:[{}]", (Object)bizDay);
        if (StringUtils.isBlank((CharSequence)bizDay)) {
            return null;
        }
        return DateUtils.parseDateByDef((String)bizDay);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public PreCheckResult preCheck(PreCheckResult preCheckResult, DboTaskRequestWrap request) throws TaskPreCheckException {
        TaskDayPO taskDayPO;
        PreCheckBizDayResult bizDayResult = new PreCheckBizDayResult();
        if (preCheckResult != null) {
            BeanUtils.copyProperties((Object)preCheckResult, (Object)bizDayResult);
        }
        if ((taskDayPO = this.taskDayService.getTaskDay(request.getTaskId())) == null || taskDayPO.getTaskDay() == null) {
            bizDayResult.setCheckSuccess(false);
            bizDayResult.setTaskResult(DboTaskResult.Failed, "preCheck:[" + request.getTaskId() + "]\u672a\u83b7\u53d6\u8c03\u5ea6\u65e5\u671f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93");
            log.error("jobRunId:[{}] taskRunId:[{}] taskId:[{}] preCheck:\u83b7\u53d6\u8c03\u5ea6\u65e5\u671f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93", new Object[]{request.getJobRunId(), request.getTaskRunId(), request.getTaskId()});
            return bizDayResult;
        }
        if (taskDayPO.getStatus() != null && StringUtils.equals((CharSequence)taskDayPO.getStatus(), (CharSequence)TaskDayUpdateStatus.Updating.name()) && !StringUtils.equals((CharSequence)taskDayPO.getJobRunId(), (CharSequence)request.getJobRunId())) {
            bizDayResult.setCheckSuccess(false);
            bizDayResult.setTaskResult(DboTaskResult.Failed, "preCheck:[" + request.getTaskId() + "]\u4e0a\u6b21\u8c03\u5ea6\u65e5\u671f\u7ffb\u724c\u5931\u8d25");
            return bizDayResult;
        }
        Date taskDay = taskDayPO.getTaskDay();
        Date bizDay = this.getBizDay(request);
        if (bizDay == null) {
            bizDayResult.setCheckSuccess(false);
            bizDayResult.setTaskResult(DboTaskResult.Failed, "preCheck:\u83b7\u53d6\u8425\u4e1a\u65e5\u671f\u5931\u8d25TaskId[" + request.getTaskId() + "]");
            log.error("jobRunId:[{}] taskRunId:[{}] \u83b7\u53d6\u8425\u4e1a\u65e5\u671f\u5931\u8d25", (Object)request.getJobRunId(), (Object)request.getTaskRunId());
            return bizDayResult;
        }
        log.debug("\u65e5\u671f\u68c0\u67e5 jobRunId:[{}] taskRunId:[{}] today:[{}] taskDay:[{}] bizDay:[{}] ", new Object[]{request.getJobRunId(), request.getTaskRunId(), DateUtils.formatDate((Date)new Date(), (String)DateUtils.PATTERN_DEFAULT), DateUtils.formatDate((Date)taskDay, (String)DateUtils.PATTERN_DEFAULT), DateUtils.formatDate((Date)bizDay, (String)DateUtils.PATTERN_DEFAULT)});
        if (DateUtils.isToday((Date)bizDay)) {
            if (DboTaskTool.compareDay(bizDay, taskDay) < 0) {
                bizDayResult.setCheckSuccess(false);
                bizDayResult.setTaskResult(DboTaskResult.Failed, "preCheck:\u8c03\u5ea6\u65e5\u671f\u5927\u4e8e\u8425\u4e1a\u65e5\u671fTaskId[" + request.getTaskId() + "]");
                log.debug("\u8425\u4e1a\u65e5\u671f\u68c0\u67e5 jobRunId:[{}] taskRunId:[{}] \u8c03\u5ea6\u65e5\u671f\u5927\u4e8e\u8425\u4e1a\u65e5\u671f", (Object)request.getJobRunId(), (Object)request.getTaskRunId());
                return bizDayResult;
            }
            bizDayResult.setCheckSuccess(true);
            log.debug("\u8425\u4e1a\u65e5\u671f\u68c0\u67e5 jobRunId:[{}] taskRunId:[{}] \u8425\u4e1a\u65e5\u671fOK", (Object)request.getJobRunId(), (Object)request.getTaskRunId());
        } else {
            bizDayResult.setCheckSuccess(false);
            bizDayResult.setTaskResult(DboTaskResult.Success, "preCheck:\u975e\u8425\u4e1a\u65e5\u671fTaskId[" + request.getTaskId() + "]");
            log.debug("\u8425\u4e1a\u65e5\u671f\u68c0\u67e5 jobRunId:[{}] taskRunId:[{}] \u4eca\u5929\u975e\u8425\u4e1a\u65e5\u671f", (Object)request.getJobRunId(), (Object)request.getTaskRunId());
        }
        bizDayResult.setBizDay(bizDay);
        bizDayResult.setTaskDay(taskDay);
        if (!this.taskDayService.updateDayStatus(request.getTaskId(), request.getJobRunId(), TaskDayUpdateStatus.Updating)) {
            log.error("job-run-id:[{}] task-run-id:[{}] \u66f4\u65b0\u8c03\u5ea6\u65e5\u671f\u4e3a\u7ffb\u724c\u4e2d\u5931\u8d25", (Object)request.getJobRunId(), (Object)request.getTaskRunId());
            bizDayResult.setCheckSuccess(false);
            bizDayResult.setTaskResult(DboTaskResult.Failed, "preCheck:[" + request.getTaskId() + "]\u66f4\u65b0\u8c03\u5ea6\u65e5\u671f\u4e3a\u7ffb\u724c\u4e2d\u5931\u8d25");
            return bizDayResult;
        }
        return bizDayResult;
    }

    @Override
    public void postCheck(PreCheckResult checkResult, DboTaskRequestWrap request, DboTaskResponse response) throws TaskPostCheckException {
        if (checkResult != null) {
            PreCheckBizDayResult checkBizDayResult = (PreCheckBizDayResult)checkResult;
            if (response.getTaskResult().equals((Object)DboTaskResult.Success)) {
                if (request.getTaskType() == DboTaskType.PartitionTask && !this.taskLogService.isTaskSuccess(request.getJobRunId(), request.getTaskRunId())) {
                    return;
                }
                log.debug("\u8c03\u5ea6\u65e5\u671f\u7ffb\u724c jobRunId:[{}] taskRunId:[{}] taskDay:[{}]", new Object[]{request.getJobRunId(), request.getTaskRunId(), DateUtils.formatDate((Date)checkBizDayResult.getTaskDay(), (String)DateUtils.PATTERN_DEFAULT)});
                if (!this.taskDayService.updateToNextDay(request.getTaskId(), request.getJobRunId(), checkBizDayResult.getTaskDay())) {
                    log.error("\u8c03\u5ea6\u65e5\u671f\u7ffb\u724c\u5931\u8d25\uff01jobRunId:[{}] taskRunId:[{}] taskDay:[{}] bizDay:[{}] ", new Object[]{request.getJobRunId(), request.getTaskRunId(), DateUtils.formatDate((Date)checkBizDayResult.getTaskDay(), (String)DateUtils.PATTERN_DEFAULT), DateUtils.formatDate((Date)checkBizDayResult.getBizDay(), (String)DateUtils.PATTERN_DEFAULT)});
                    throw new TaskPostCheckException("postCheck:[" + request.getTaskId() + "]\u8c03\u5ea6\u65e5\u671f\u7ffb\u724c\u5931\u8d25");
                }
            }
        }
        if (!this.taskDayService.updateDayStatus(request.getTaskId(), request.getJobRunId(), TaskDayUpdateStatus.Updated)) {
            log.error("job-run-id:[{}] task-run-id:[{}] \u6062\u590d\u8c03\u5ea6\u65e5\u671f\u7ffb\u724c\u72b6\u6001\u4e3aUpdated\u5931\u8d25", (Object)request.getJobRunId(), (Object)request.getTaskRunId());
            throw new TaskPostCheckException("postCheck:[" + request.getTaskId() + "]\u6062\u590d\u8c03\u5ea6\u65e5\u671f\u7ffb\u724c\u72b6\u6001\u4e3aUpdated\u5931\u8d25");
        }
    }
}

