/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.model.IterableModel;
import cn.com.yusys.yusp.commons.file.api.FileInfo;
import cn.com.yusys.yusp.commons.file.util.FileInfoUtils;
import com.shch.sfc.components.excelcsv.AbstractEfDataHandle;
import com.shch.sfc.components.excelcsv.ExportContext;
import com.shch.sfc.components.excelcsv.ExportProxy;
import com.shch.sfc.components.excelcsv.ExporterImporter;
import com.shch.sfc.components.excelcsv.ModalInfo;
import com.shch.sfc.components.excelcsv.ProgressInfo;
import com.shch.sfc.core.context.SfcContext;
import com.shch.sfc.metadata.dict.Dicts;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import net.sf.cglib.core.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ExportTask.class);
    private final ExportContext ec;
    private final int maxPages;
    private final int pageSize;
    private String taskId;
    private String root;
    private ProgressInfo progressInfo;

    public ExportTask(ExportContext ec, int maxPages, int pageSize) {
        this.ec = ec;
        this.maxPages = maxPages;
        this.pageSize = pageSize <= 0 ? 5000 : pageSize;
        this.progressInfo = new ProgressInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.taskId = SfcContext.get().getReplyMsgId();
        this.progressInfo.setTaskId(this.taskId);
        File outFile = null;
        try {
            this.ec.progress.set(this.taskId, this.progressInfo);
            outFile = this.exportTask();
            log.info("export finished.");
            FileInfo fileInfo = ExporterImporter.uploadTmpFile(outFile);
            String fileInfoIdentity = FileInfoUtils.toIdentity((FileInfo)fileInfo);
            this.progressInfo.setProcessRecord(100L);
            this.progressInfo.setFileId(fileInfoIdentity);
            this.ec.progress.set(this.taskId, this.progressInfo);
        }
        catch (Throwable e) {
            log.error("error.", e);
            this.progressInfo.setProcessRecord(-1L);
            this.ec.progress.set(this.taskId, this.progressInfo);
        }
        finally {
            if (outFile != null && outFile.exists() && !outFile.delete()) {
                log.warn("temp file {} delete failed, please delete manually.", (Object)outFile.getPath());
            }
            Dicts.clearThreadLocal();
        }
    }

    public File exportTask() throws Throwable {
        ExportProxy exportProxy = this.ec.method.getAnnotation(ExportProxy.class);
        Class<? extends AbstractEfDataHandle> dataHandleClass = exportProxy.handle();
        this.root = exportProxy.root();
        Class<?> headClass = exportProxy.headClass();
        AbstractEfDataHandle dataHandle = (AbstractEfDataHandle)ReflectUtils.newInstance(dataHandleClass);
        String fileType = SfcContext.get().getExportFlag();
        if (ExporterImporter.FILE_TYPE_LIST.contains(fileType.toLowerCase())) {
            IterableModel model = new IterableModel(this::queryResultByPage, this.maxPages);
            return this.ec.exporterImporter.export(headClass, model, dataHandle);
        }
        Collection<?> collectionModal = this.findCollectionModal(this.ec.proxy.invokeSuper(this.ec.obj, this.ec.args));
        Object model = collectionModal.iterator().next();
        return this.ec.exporterImporter.export(model);
    }

    private Collection<?> queryResultByPage(int pageNum) {
        try {
            SfcContext sfcContext = SfcContext.get();
            sfcContext.setPageNum(Integer.valueOf(pageNum)).setPageSize(Integer.valueOf(this.pageSize));
            Object ret = this.ec.proxy.invokeSuper(this.ec.obj, this.ec.args);
            Collection<?> resultModel = this.findCollectionModal(ret);
            int percent = (int)((double)pageNum / (double)this.maxPages * 100.0);
            this.progressInfo.setProgressBar(percent);
            long alreadyCount = this.progressInfo.getProcessRecord();
            this.progressInfo.setProcessRecord(alreadyCount + (long)resultModel.size());
            this.ec.progress.set(this.taskId, this.progressInfo);
            return this.findCollectionModal(ret);
        }
        catch (Throwable e) {
            this.progressInfo.setProgressBar(-1);
            this.ec.progress.set(this.taskId, this.progressInfo);
            log.error("error.", e);
            return Collections.emptyList();
        }
    }

    private Collection<?> findCollectionModal(Object obj) {
        Object modal = obj;
        if ((modal = ModalInfo.of(modal, this.root).getModalObject()) instanceof Collection) {
            return (Collection)modal;
        }
        return Collections.singletonList(modal);
    }
}

