/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.excelcsv.handle.ExcelCsvHead;
import cn.com.yusys.yusp.commons.excelcsv.util.CommonFunctions;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import com.shch.sfc.components.excelcsv.Ef;
import com.shch.sfc.components.excelcsv.FieldInfo;
import com.shch.sfc.core.context.message.header.GeneralMessageHelper;
import com.shch.sfc.metadata.api.IDict;
import com.shch.sfc.metadata.api.IStdField;
import com.shch.sfc.metadata.api.NullDict;
import com.shch.sfc.metadata.dict.Dicts;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public abstract class AbstractEfDataHandle
implements DataHandle {
    private static final Class<?>[] BASIC_NUM_TYPE = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final Class<?>[] NORMAL_DATA_TYPE = new Class[]{Date.class, LocalDate.class, LocalDateTime.class};
    private static final ThreadLocal<Map<Class<?>, List<FieldInfo>>> CACHE = ThreadLocal.withInitial(HashMap::new);
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public Object handle(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof CommonFunctions.Dict) {
            CommonFunctions.Dict dict = (CommonFunctions.Dict)obj;
            dict.setItemValue(this.translate(dict.getDictCode(), dict.getSrcValue(), "zh_cn"));
            dict.setItemValueEn(this.translate(dict.getDictCode(), dict.getSrcValue(), "en_us"));
            return dict;
        }
        String lang = GeneralMessageHelper.request().sys().getLangCode();
        this.doTranslate(obj, lang);
        return this.doHandle(obj);
    }

    private void doTranslate(Object obj, String lang) {
        Map<Class<?>, List<FieldInfo>> cacheMap = CACHE.get();
        List<FieldInfo> fieldInfos = cacheMap.get(obj.getClass());
        if (fieldInfos != null && !fieldInfos.isEmpty()) {
            fieldInfos.forEach(fieldInfo -> {
                if (fieldInfo.getDictClass() != null && fieldInfo.getDictClass() != NullDict.class) {
                    String transValue = this.translate(fieldInfo.getDictClass(), String.valueOf(BeanUtils.getObjectFieldValue((Object)obj, (Field)fieldInfo.getField())), lang);
                    BeanUtils.setObjectFieldValue((Object)obj, (Field)fieldInfo.getField(), (Object)transValue);
                } else if (!fieldInfo.getDictCode().isEmpty()) {
                    String transValue = this.translate(fieldInfo.getDictCode(), String.valueOf(BeanUtils.getObjectFieldValue((Object)obj, (Field)fieldInfo.getField())), lang);
                    BeanUtils.setObjectFieldValue((Object)obj, (Field)fieldInfo.getField(), (Object)transValue);
                }
            });
        }
    }

    private String translate(String dictCode, String srcValue, String lang) {
        if (dictCode == null || srcValue == null) {
            return srcValue;
        }
        String result = srcValue;
        IDict iDict = Dicts.fromThreadLocal().valueOf(dictCode, srcValue);
        if (iDict != null) {
            result = srcValue.equals(iDict.value()) ? ("zh_cn".equals(lang) ? iDict.itemName() : iDict.itemNameEn()) : iDict.value();
        }
        return result;
    }

    private String translate(Class<? extends IDict> dictClass, String srcValue, String lang) {
        if (dictClass == null || srcValue == null) {
            return srcValue;
        }
        IDict dict = Dicts.valueOf(dictClass, (String)srcValue);
        if (dict == null) {
            return srcValue;
        }
        return srcValue.equals(dict.value()) ? ("zh_cn".equals(lang) ? dict.itemName() : dict.itemNameEn()) : dict.value();
    }

    public abstract Object doHandle(Object var1);

    public LinkedList<ExcelCsvHead> analysis(Class<?> headClass) {
        if (headClass == null) {
            throw new IllegalArgumentException("headClass can not be null");
        }
        Map<Class<?>, List<FieldInfo>> cacheMap = CACHE.get();
        List fieldInfos = cacheMap.computeIfAbsent(headClass, this::getFieldInfos);
        LinkedList<ExcelCsvHead> excelCsvHeads = new LinkedList<ExcelCsvHead>();
        fieldInfos.forEach(fieldInfo -> excelCsvHeads.add(this.createExcelCsvHead((FieldInfo)fieldInfo)));
        return excelCsvHeads;
    }

    private List<FieldInfo> getFieldInfos(Class<?> headClass) {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        Field[] fields = headClass.getDeclaredFields();
        Stream.of(fields).forEach(field -> fieldInfos.add(field.isAnnotationPresent(Ef.class) ? new FieldInfo((Field)field, field.getAnnotation(Ef.class)) : new FieldInfo((Field)field)));
        return this.assignOrder(fieldInfos);
    }

    private List<FieldInfo> assignOrder(List<FieldInfo> fieldInfos) {
        int position;
        ArrayList<FieldInfo> orderedFieldInfo = new ArrayList<FieldInfo>();
        ArrayList<Integer> alreadyOrder = new ArrayList<Integer>();
        for (FieldInfo fieldInfo : fieldInfos) {
            if (fieldInfo.getOrder() > 0) {
                position = this.getOrder(alreadyOrder, fieldInfo.getOrder(), fieldInfo.getOrder());
                alreadyOrder.add(position);
                fieldInfo.setOrder(position);
                orderedFieldInfo.add(fieldInfo);
            }
            if (fieldInfo.getOrder() >= 0) continue;
            orderedFieldInfo.add(fieldInfo);
        }
        for (FieldInfo fieldInfo : fieldInfos) {
            if (fieldInfo.getOrder() != 0) continue;
            position = this.getOrder(alreadyOrder, 0, fieldInfo.getOrder());
            alreadyOrder.add(position);
            fieldInfo.setOrder(position);
            orderedFieldInfo.add(fieldInfo);
        }
        return orderedFieldInfo;
    }

    private int getOrder(List<Integer> alreadyOrder, int index, int currentOrder) {
        if (!alreadyOrder.contains(currentOrder)) {
            return currentOrder;
        }
        if (!alreadyOrder.contains(index)) {
            return index;
        }
        int position = index;
        while (alreadyOrder.contains(++position)) {
        }
        return position;
    }

    private ExcelCsvHead createExcelCsvHead(FieldInfo fieldInfo) {
        String langCode;
        IStdField stdField;
        Object dict = null;
        if (fieldInfo.getDictClass() != null) {
            dict = fieldInfo.getDictClass();
        }
        if (fieldInfo.getDictCode() != null && !fieldInfo.getDictCode().isEmpty()) {
            dict = fieldInfo.getDictCode();
        }
        ExcelCsvHead.FormatType formatType = null;
        String formatPattern = "";
        if (fieldInfo.getFormat() != null && !fieldInfo.getFormat().isEmpty()) {
            Class<?> fieldType = fieldInfo.getField().getType();
            Object object = AbstractEfDataHandle.isDateType(fieldType) ? ExcelCsvHead.FormatType.DATE : (formatType = Number.class.isAssignableFrom(fieldType) || AbstractEfDataHandle.isBasicNum(fieldType) ? ExcelCsvHead.FormatType.NUM : null);
            String string = fieldInfo.getFormat().isEmpty() ? (formatType == ExcelCsvHead.FormatType.DATE ? DEFAULT_DATE_FORMAT : "") : (formatPattern = fieldInfo.getFormat());
        }
        String title = (stdField = fieldInfo.getStdField()) != null ? ("zh_cn".equals(langCode = GeneralMessageHelper.request().sys().getLangCode()) ? stdField.nameCn() : stdField.name()) : (fieldInfo.getTitle() != null && !fieldInfo.getTitle().isEmpty() ? fieldInfo.getTitle() : fieldInfo.getName());
        return new ExcelCsvHead(Integer.valueOf(fieldInfo.getOrder()), fieldInfo.getName(), title, fieldInfo.getViewLength(), formatType, formatPattern, dict);
    }

    private static boolean isBasicNum(Class<?> fieldType) {
        return Stream.of(BASIC_NUM_TYPE).anyMatch(type -> type == fieldType);
    }

    private static boolean isDateType(Class<?> fieldType) {
        return Stream.of(NORMAL_DATA_TYPE).anyMatch(type -> type == fieldType);
    }

    public static class DefaultDataHandle
    extends AbstractEfDataHandle {
        @Override
        public Object doHandle(Object o) {
            return o;
        }
    }
}

