/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.model.IterableModel;
import cn.com.yusys.yusp.commons.file.api.FileInfo;
import cn.com.yusys.yusp.commons.file.util.FileInfoUtils;
import com.shch.sfc.components.excelcsv.AbstractEfDataHandle;
import com.shch.sfc.components.excelcsv.ExportContext;
import com.shch.sfc.components.excelcsv.ExportProxy;
import com.shch.sfc.components.excelcsv.ExporterImporter;
import com.shch.sfc.components.excelcsv.ModalInfo;
import com.shch.sfc.core.context.message.header.GeneralMessageHelper;
import com.shch.sfc.core.context.message.header.model.RequestAppHead;
import com.shch.sfc.metadata.dict.Dicts;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import net.sf.cglib.core.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ExportTask.class);
    private final ExportContext ec;
    private final int maxPages;
    private final int pageSize;
    private String taskId;
    private String root;

    public ExportTask(ExportContext ec, int maxPages, int pageSize) {
        this.ec = ec;
        this.maxPages = maxPages;
        this.pageSize = pageSize <= 0 ? 5000 : pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.taskId = GeneralMessageHelper.request().app().getReplyMsgId();
        File outFile = null;
        try {
            this.ec.progress.set(this.taskId, 0);
            outFile = this.exportTask();
            log.info("export finished.");
            FileInfo fileInfo = ExporterImporter.uploadTmpFile(outFile);
            String fileInfoIdentity = FileInfoUtils.toIdentity((FileInfo)fileInfo);
            this.ec.progress.set(this.taskId, 100);
            this.ec.notification.notice(fileInfoIdentity, null);
        }
        catch (Throwable e) {
            log.error("error.", e);
            this.ec.progress.set(this.taskId, -1);
            this.ec.notification.notice("error.", e);
        }
        finally {
            if (outFile != null && outFile.exists() && !outFile.delete()) {
                log.warn("temp file {} delete failed, please delete manually.", (Object)outFile.getPath());
            }
            Dicts.clearThreadLocal();
        }
    }

    public File exportTask() throws Throwable {
        ExportProxy exportProxy = this.ec.method.getAnnotation(ExportProxy.class);
        Class<? extends AbstractEfDataHandle> dataHandleClass = exportProxy.handle();
        this.root = exportProxy.root();
        Class<?> headClass = exportProxy.headClass();
        AbstractEfDataHandle dataHandle = (AbstractEfDataHandle)ReflectUtils.newInstance(dataHandleClass);
        String fileType = GeneralMessageHelper.request().app().getExportFlag();
        if (ExporterImporter.FILE_TYPE_LIST.contains(fileType.toLowerCase())) {
            IterableModel model = new IterableModel(this::queryResultByPage, this.maxPages);
            return this.ec.exporterImporter.export(headClass, model, dataHandle);
        }
        Collection<?> collectionModal = this.findCollectionModal(this.ec.proxy.invokeSuper(this.ec.obj, this.ec.args));
        Object model = collectionModal.iterator().next();
        return this.ec.exporterImporter.export(model);
    }

    private Collection<?> queryResultByPage(int pageNum) {
        try {
            RequestAppHead appHead = GeneralMessageHelper.request().app();
            appHead.setPageNum(Integer.valueOf(pageNum));
            appHead.setPageSize(Integer.valueOf(this.pageSize));
            GeneralMessageHelper.request().refresh(appHead);
            Object ret = this.ec.proxy.invokeSuper(this.ec.obj, this.ec.args);
            int percent = (int)((double)pageNum / (double)this.maxPages * 100.0);
            this.ec.progress.set(this.taskId, percent);
            return this.findCollectionModal(ret);
        }
        catch (Throwable e) {
            this.ec.progress.set(this.taskId, -1);
            this.ec.notification.notice("error.", e);
            log.error("error.", e);
            return Collections.emptyList();
        }
    }

    private Collection<?> findCollectionModal(Object obj) {
        Object modal = obj;
        if ((modal = ModalInfo.of(modal, this.root).getModalObject()) instanceof Collection) {
            return (Collection)modal;
        }
        return Collections.singletonList(modal);
    }
}

