/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.excelcsv;

import cn.com.yusys.yusp.commons.util.StringUtils;
import com.shch.sfc.components.excelcsv.IProgress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class DefaultRedisProgress
implements IProgress {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRedisProgress.class);
    private final StringRedisTemplate stringRedisTemplate;
    private static final String REDIS_GROUP_PREFIX = "ExcelCsvTask";
    private static final String SPLIT_SYMBOL = ":";
    private final long timeout;

    public DefaultRedisProgress(StringRedisTemplate stringRedisTemplate, long timeout) {
        Objects.requireNonNull(stringRedisTemplate, "StringRedisTemplate can not be null.");
        this.stringRedisTemplate = stringRedisTemplate;
        this.timeout = timeout;
    }

    @Override
    public void set(String taskId, int percent) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            logger.warn("the task id is blank. please check.");
            return;
        }
        String key = "ExcelCsvTask:" + taskId;
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)String.valueOf(percent), this.timeout, TimeUnit.MINUTES);
    }

    @Override
    public int progress(String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            logger.warn("the task id is blank. please check.");
            return 0;
        }
        String key = "ExcelCsvTask:" + taskId;
        String result = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isBlank((CharSequence)result)) {
            return 0;
        }
        return Integer.parseInt(result);
    }
}

