/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.model.IterableModel;
import cn.com.yusys.yusp.commons.module.query.QueryModel;
import com.shch.sfc.components.excelcsv.AbstractEfDataHandle;
import com.shch.sfc.components.excelcsv.ExportContext;
import com.shch.sfc.components.excelcsv.ExportProxy;
import com.shch.sfc.components.excelcsv.ExporterImporter;
import com.shch.sfc.components.excelcsv.ModalInfo;
import com.shch.sfc.components.excelcsv.metadata.Dicts;
import com.shch.sfc.core.context.message.header.GeneralMessageHelper;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import net.sf.cglib.core.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ExportTask.class);
    private final ExportContext ec;
    private final int maxPages;
    private String taskId;
    private String root;

    public ExportTask(ExportContext exportContext, int maxPages) {
        this.ec = exportContext;
        this.maxPages = maxPages;
    }

    @Override
    public void run() {
        this.taskId = GeneralMessageHelper.request().app().getReplyMsgId();
        File outFile = null;
        try {
            try {
                this.ec.progress.set(this.taskId, 0);
                outFile = this.exportTask();
                log.info("export finished.");
                Object result = this.ec.fileOperate.upload(outFile);
                this.ec.progress.set(this.taskId, 100);
                this.ec.notification.notice(result, null);
            }
            catch (Throwable e) {
                log.error("error.", e);
                this.ec.progress.set(this.taskId, -1);
                this.ec.notification.notice("error.", e);
                if (outFile != null && outFile.exists() && !outFile.delete()) {
                    log.warn("temp file {} delete failed, please delete manually.", (Object)outFile.getPath());
                }
                Dicts.clearThreadLocal();
            }
        }
        finally {
            if (outFile != null && outFile.exists() && !outFile.delete()) {
                log.warn("temp file {} delete failed, please delete manually.", (Object)outFile.getPath());
            }
            Dicts.clearThreadLocal();
        }
    }

    public File exportTask() throws Throwable {
        ExportProxy exportProxy = this.ec.method.getAnnotation(ExportProxy.class);
        Class<? extends AbstractEfDataHandle> dataHandleClass = exportProxy.handle();
        this.root = exportProxy.root();
        Class<?> headClass = exportProxy.headClass();
        QueryModel queryModel = new QueryModel();
        int pageSize = GeneralMessageHelper.request().app().getPageSize();
        queryModel.setSize(pageSize <= 0 ? 1000 : pageSize);
        AbstractEfDataHandle dataHandle = (AbstractEfDataHandle)ReflectUtils.newInstance(dataHandleClass);
        String fileType = GeneralMessageHelper.request().app().getExportFlag();
        if (ExporterImporter.FILE_TYPE_LIST.contains(fileType.toLowerCase())) {
            IterableModel model = new IterableModel(this::queryResultByQueryModel, this.maxPages, queryModel);
            return this.ec.exporterImporter.export(headClass, (Object)model, dataHandle);
        }
        Collection<?> collectionModal = this.findCollectionModal(this.ec.proxy.invokeSuper(this.ec.obj, this.ec.args));
        Object model = collectionModal.iterator().next();
        return this.ec.exporterImporter.export(model);
    }

    private Collection<?> queryResultByQueryModel(QueryModel queryModel) {
        try {
            GeneralMessageHelper.request().app().setPageNum(Integer.valueOf(queryModel.getPage()));
            Object ret = this.ec.proxy.invokeSuper(this.ec.obj, this.ec.args);
            int percent = (int)((double)queryModel.getPage() / (double)this.maxPages * 100.0);
            this.ec.progress.set(this.taskId, percent);
            return this.findCollectionModal(ret);
        }
        catch (Throwable e) {
            this.ec.progress.set(this.taskId, -1);
            this.ec.notification.notice("error.", e);
            log.error("error.", e);
            return Collections.emptyList();
        }
    }

    private Collection<?> findCollectionModal(Object obj) {
        Object modal = obj;
        if ((modal = ModalInfo.of(modal, this.root).getModalObject()) instanceof Collection) {
            return (Collection)modal;
        }
        return Collections.singletonList(modal);
    }
}

