/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.BillTemplate;
import cn.com.yusys.yusp.commons.excelcsv.CsvTemplate;
import cn.com.yusys.yusp.commons.excelcsv.ExcelTemplate;
import cn.com.yusys.yusp.commons.excelcsv.XmlTemplate;
import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.excelcsv.model.IterableModel;
import cn.com.yusys.yusp.commons.excelcsv.util.TemplateManager;
import cn.com.yusys.yusp.commons.module.query.QueryModel;
import com.shch.sfc.components.excelcsv.AbstractEfDataHandle;
import com.shch.sfc.core.context.message.header.GeneralMessageHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExporterImporter {
    private static final Logger log = LoggerFactory.getLogger(ExporterImporter.class);
    public static final List<String> FILE_TYPE_LIST = Collections.unmodifiableList(Arrays.asList("csv", "xls", "xlsx"));
    private final int maxPages;
    private final int sheetMaxRow;
    private final String tempFileDir;

    public ExporterImporter(int maxPages, int sheetMaxRow, String tempFileDir) {
        this.maxPages = maxPages <= 0 ? 10 : maxPages;
        int n = this.sheetMaxRow = sheetMaxRow <= 0 ? -1 : sheetMaxRow;
        if (tempFileDir == null || tempFileDir.isEmpty()) {
            throw new IllegalArgumentException("the temp file dir can not be null.");
        }
        this.tempFileDir = tempFileDir.endsWith("\\") || tempFileDir.endsWith("/") ? tempFileDir : String.valueOf(tempFileDir) + File.separator;
        try {
            FileUtils.forceMkdir((File)new File(this.tempFileDir));
        }
        catch (IOException e) {
            throw new IllegalStateException("can not make directory " + this.tempFileDir);
        }
    }

    public File export(Class<?> headClass, Object model) {
        return this.export(headClass, model, new AbstractEfDataHandle.DefaultDataHandle());
    }

    public File export(Class<?> headClass, Object model, FileType fileType) {
        return this.export(headClass, model, new AbstractEfDataHandle.DefaultDataHandle(), fileType);
    }

    public File export(Class<?> headClass, Function<QueryModel, Collection<?>> queryFun, QueryModel queryModel) {
        IterableModel model = new IterableModel(queryFun, this.maxPages, queryModel);
        return this.export(headClass, (Object)model, new AbstractEfDataHandle.DefaultDataHandle());
    }

    public File export(Class<?> headClass, Object model, AbstractEfDataHandle dataHandle) {
        return this.simpleExport(headClass, model, dataHandle, this.checkFileTypeInContext(true));
    }

    public File export(Class<?> headClass, Object model, AbstractEfDataHandle dataHandle, FileType fileType) {
        return this.simpleExport(headClass, model, dataHandle, fileType.getType());
    }

    public byte[] exportForBytes(Class<?> headClass, Object model) {
        return this.exportForBytes(headClass, model, new AbstractEfDataHandle.DefaultDataHandle());
    }

    public byte[] exportForBytes(Class<?> headClass, Object model, FileType fileType) {
        return this.exportForBytes(headClass, model, new AbstractEfDataHandle.DefaultDataHandle(), fileType);
    }

    public byte[] exportForBytes(Class<?> headClass, Function<QueryModel, Collection<?>> queryFun, QueryModel queryModel) {
        IterableModel model = new IterableModel(queryFun, this.maxPages, queryModel);
        return this.exportForBytes(headClass, (Object)model, new AbstractEfDataHandle.DefaultDataHandle());
    }

    public byte[] exportForBytes(Class<?> headClass, Object model, AbstractEfDataHandle dataHandle) {
        return this.getFileBytes(this.simpleExport(headClass, model, dataHandle, this.checkFileTypeInContext(true)));
    }

    public byte[] exportForBytes(Class<?> headClass, Object model, AbstractEfDataHandle dataHandle, FileType fileType) {
        return this.getFileBytes(this.simpleExport(headClass, model, dataHandle, fileType.getType()));
    }

    private File simpleExport(Class<?> headClass, Object model, AbstractEfDataHandle dataHandle, String fileType) {
        Objects.requireNonNull(headClass, "headClass can not be null.");
        Objects.requireNonNull(model, "model can not be null.");
        Objects.requireNonNull(dataHandle, "dataHandle can not be null.");
        File outFile = new File(this.getOutFilePath(fileType));
        try {
            if ("csv".equals(fileType)) {
                log.info("export csv file.");
                CsvTemplate csvTemplate = new CsvTemplate(headClass, (DataHandle)dataHandle);
                csvTemplate.export(model, outFile);
            } else {
                log.info("export excel file.");
                ExcelTemplate excelTemplate = new ExcelTemplate(headClass, this.sheetMaxRow, (DataHandle)dataHandle);
                excelTemplate.export(model, outFile);
            }
            return outFile;
        }
        catch (Exception e) {
            throw new IllegalStateException("export failed.", e);
        }
    }

    public File export(Object model) {
        return this.export(this.checkFileTypeInContext(false), model);
    }

    public File export(String templateName, Object model) {
        return this.billExport(templateName, model);
    }

    public byte[] exportForBytes(Object model) {
        return this.exportForBytes(this.checkFileTypeInContext(false), model);
    }

    public byte[] exportForBytes(String templateName, Object model) {
        return this.getFileBytes(this.billExport(templateName, model));
    }

    private File billExport(String templateName, Object model) {
        try {
            File outFile;
            String fileExtName = templateName.substring(templateName.lastIndexOf(".") + 1);
            if ("ftl".equalsIgnoreCase(fileExtName)) {
                outFile = new File(this.getOutFilePath(fileExtName));
                XmlTemplate xmlTemplate = new XmlTemplate(templateName, (DataHandle)new AbstractEfDataHandle.DefaultDataHandle());
                xmlTemplate.export(model, outFile);
            } else {
                outFile = new File(this.getOutFilePath(fileExtName));
                BillTemplate billTemplate = TemplateManager.getInstance().readTemplate(templateName, (DataHandle)new AbstractEfDataHandle.DefaultDataHandle());
                billTemplate.export(model, outFile);
            }
            return outFile;
        }
        catch (Exception e) {
            throw new IllegalStateException("export bill failed.", e);
        }
    }

    public void importData(Class<?> headClass, File inFile, Consumer<Object> handleFun) {
        this.importData(headClass, inFile, new AbstractEfDataHandle.DefaultDataHandle(), handleFun);
    }

    public void importData(Class<?> headClass, File inFile, AbstractEfDataHandle dataHandle, Consumer<Object> handleFun) {
        block4: {
            Objects.requireNonNull(headClass, "headClass can not be null.");
            Objects.requireNonNull(inFile, "file can not be null.");
            Objects.requireNonNull(dataHandle, "dataHandle can not be null.");
            Objects.requireNonNull(handleFun, "handleFun can not be null.");
            try {
                String fileName = inFile.getName().toLowerCase();
                if (fileName.endsWith(".csv")) {
                    CsvTemplate csvTemplate = new CsvTemplate(headClass, (DataHandle)dataHandle);
                    csvTemplate.importData(inFile, handleFun);
                    break block4;
                }
                if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) {
                    ExcelTemplate excelTemplate = new ExcelTemplate(headClass, 1000, (DataHandle)dataHandle);
                    excelTemplate.importData(inFile, handleFun);
                    break block4;
                }
                throw new IllegalArgumentException("the file type " + fileName + " is not supported.");
            }
            catch (Exception e) {
                throw new IllegalStateException("import error.", e);
            }
        }
    }

    private String checkFileTypeInContext(boolean isSimple) {
        String exportFlag = GeneralMessageHelper.request().app().getExportFlag();
        if (exportFlag == null) {
            throw new IllegalStateException("the export flag in context is null.");
        }
        if (isSimple && !FILE_TYPE_LIST.contains(exportFlag)) {
            throw new IllegalStateException("must specify an explicit export type [xls/xlsx/csv] in context");
        }
        if (!isSimple && FILE_TYPE_LIST.contains(exportFlag)) {
            throw new IllegalStateException("must specify an explicit template name in context or you can manually specify the template name");
        }
        return exportFlag;
    }

    private byte[] getFileBytes(File outFile) {
        if (outFile.exists()) {
            try {
                byte[] byArray;
                block17: {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    FileInputStream is = new FileInputStream(outFile);
                    try {
                        byArray = IOUtils.toByteArray((InputStream)is);
                        if (is == null) break block17;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                if (is != null) {
                                    ((InputStream)is).close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            throw new IllegalStateException("export failed.");
                        }
                    }
                    ((InputStream)is).close();
                }
                return byArray;
            }
            finally {
                if (!outFile.delete()) {
                    log.warn("delete temp file {} failed. please delete manually", (Object)outFile.getPath());
                }
            }
        }
        throw new IllegalStateException("export failed. the file is not exists.");
    }

    private String getOutFilePath(String fileType) {
        String suffix = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS"));
        return String.valueOf(this.tempFileDir) + "shch-export-" + suffix + "." + fileType;
    }

    public static enum FileType {
        XLS("xls"),
        XLSX("xlsx"),
        CSV("csv");

        private final String type;

        private FileType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

