/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.excelcsv.metadata;

import com.shch.sfc.components.excelcsv.metadata.IDict;
import com.shch.sfc.components.excelcsv.metadata.IDictFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class Dicts {
    private static final ConcurrentHashMap<String, IDict> DICT_VALUE_CACHE = new ConcurrentHashMap(8);
    private static final List<IDictFactory> FACTORIES = new ArrayList<IDictFactory>();
    private static final List<String> PACKAGES = new ArrayList<String>();
    private static final ThreadLocal<Dicts> LOCAL_INSTANCE = new ThreadLocal();
    private final HashMap<String, IDict> instanceCache = new HashMap();

    public static Dicts fromThreadLocal() {
        Dicts instace = LOCAL_INSTANCE.get();
        if (instace == null) {
            instace = new Dicts();
            LOCAL_INSTANCE.set(instace);
        }
        return instace;
    }

    public static void clearThreadLocal() {
        LOCAL_INSTANCE.remove();
    }

    public static IDict valueOf(Class<? extends IDict> dictClass, String value) {
        if (value == null) {
            return null;
        }
        String key = dictClass.getSimpleName() + "$" + value;
        return DICT_VALUE_CACHE.computeIfAbsent(key, k -> {
            IDict[] items = (IDict[])dictClass.getEnumConstants();
            return Arrays.stream(items).filter(i -> value.equals(i.value()) || value.equals(i.itemName()) || value.equals(i.itemNameEn())).findAny().orElse(null);
        });
    }

    public static Class<? extends IDict> tryFindEnumClass(String dictCode) {
        for (String pack : PACKAGES) {
            String className = pack + dictCode;
            try {
                return Dicts.class.getClassLoader().loadClass(className).asSubclass(IDict.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public IDict valueOf(String dictCode, String value) {
        String prefix = dictCode + "$";
        String key = prefix + value;
        if (DICT_VALUE_CACHE.containsKey(prefix)) {
            return DICT_VALUE_CACHE.get(key);
        }
        if (!this.instanceCache.containsKey(prefix)) {
            Class<? extends IDict> enumClass = Dicts.tryFindEnumClass(dictCode);
            if (enumClass != null && enumClass.isEnum()) {
                this.cache(Arrays.stream(enumClass.getEnumConstants()), prefix);
            } else {
                this.cache(FACTORIES.stream().flatMap(f -> Arrays.stream(f.createDictItems(dictCode))), prefix);
            }
            this.instanceCache.put(prefix, null);
        }
        return this.instanceCache.get(key);
    }

    private void cache(Stream<IDict> stream, String prefix) {
        stream.forEach(d -> {
            this.instanceCache.put(prefix + d.value(), (IDict)d);
            this.instanceCache.put(prefix + d.itemName(), (IDict)d);
            if (d.itemNameEn() != null && !d.itemNameEn().isEmpty()) {
                this.instanceCache.put(prefix + d.itemNameEn(), (IDict)d);
            }
        });
    }

    private Dicts() {
    }

    static {
        ServiceLoader.load(IDictFactory.class).forEach(FACTORIES::add);
        PACKAGES.add("com.shch.sfc.components.excelcsv.metadata.");
    }
}

