/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.excelcsv;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.ObjectContext;

public class ModalInfo {
    private static final ConcurrentHashMap<Class<?>, ModalInfo> CACHE = new ConcurrentHashMap();
    private static final JexlEngine JEXL_ENGINE = new JexlBuilder().silent(false).create();
    private JexlExpression expression;
    private Object modalObject;

    public static ModalInfo of(Object modal, String root) {
        Class<?> modalClass = modal.getClass();
        ModalInfo info = root != null && !root.isEmpty() ? CACHE.computeIfAbsent(modalClass, x -> new ModalInfo(root)) : new ModalInfo();
        info.modalObject = modal;
        return info;
    }

    private ModalInfo() {
    }

    ModalInfo(String root) {
        this.parseEm(root);
    }

    private void parseEm(String root) {
        if (root != null && !root.isEmpty()) {
            this.expression = JEXL_ENGINE.createExpression(root);
        }
    }

    private ModalInfo newInstance() {
        ModalInfo copy = new ModalInfo();
        copy.expression = this.expression;
        return copy;
    }

    public Object getModalObject() {
        if (this.expression == null) {
            return this.modalObject;
        }
        try {
            return this.expression.evaluate((JexlContext)new ObjectContext(JEXL_ENGINE, this.modalObject));
        }
        catch (Exception e) {
            throw new IllegalStateException("can not find template data. please check ExportProxy.root", e);
        }
    }
}

