/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.components.excelcsv;

import cn.com.yusys.yusp.commons.util.StringUtils;
import com.shch.sfc.components.excelcsv.Ef;
import com.shch.sfc.components.excelcsv.metadata.IDict;
import com.shch.sfc.components.excelcsv.metadata.IStdField;
import com.shch.sfc.components.excelcsv.metadata.NullDict;
import com.shch.sfc.components.excelcsv.metadata.StdFields;
import com.shch.sfc.core.context.message.header.GeneralMessageHelper;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;

public class FieldInfo {
    private final Field field;
    private final String name;
    private final IStdField stdField;
    private final Class<? extends IDict> dictClass;
    private final String dictCode;
    private final String title;
    private final int length;
    private int order;
    private int viewLength;
    private final String format;

    FieldInfo(Field field) {
        this.field = Optional.of(field).orElseThrow(() -> new NullPointerException("the field is null."));
        this.name = field.getName();
        this.stdField = this.resolveStdField(field, null);
        if (this.stdField == null) {
            this.dictClass = null;
            this.length = -1;
        } else {
            this.length = this.stdField.length();
            this.dictClass = this.stdField.dictClass();
        }
        this.dictCode = "";
        this.title = this.resolveTitle(field, this.stdField, null);
        this.order = 0;
        this.format = "";
    }

    FieldInfo(Field field, Ef ef) {
        Class<? extends IDict> dictCls;
        this.field = Optional.of(field).orElseThrow(() -> new NullPointerException("the field is null."));
        Objects.requireNonNull(ef, "Ef can not be null.");
        this.name = field.getName();
        this.stdField = this.resolveStdField(field, ef);
        if (this.stdField == null) {
            this.length = -1;
            dictCls = null;
        } else {
            this.length = this.stdField.length();
            dictCls = this.stdField.dictClass();
        }
        this.title = this.resolveTitle(field, this.stdField, ef);
        if (!NullDict.class.equals(ef.dictClass())) {
            dictCls = ef.dictClass();
        }
        this.dictClass = dictCls;
        this.dictCode = ef.dictCode();
        this.viewLength = ef.viewLength();
        this.order = ef.order();
        this.format = ef.format();
    }

    private IStdField resolveStdField(Field field, Ef ef) {
        if (ef != null && !ef.stdField().isEmpty()) {
            return StdFields.getField(ef.stdField());
        }
        if (field != null) {
            return StdFields.getField(StringUtils.hump2Underline((String)field.getName()));
        }
        return null;
    }

    private String resolveTitle(Field field, IStdField stdField, Ef ef) {
        if (stdField != null) {
            if ("zh_cn".equals(GeneralMessageHelper.request().sys().getLangCode())) {
                return stdField.nameCn();
            }
            return stdField.name();
        }
        if (ef != null && !ef.title().isEmpty()) {
            return ef.title();
        }
        if (field != null) {
            return field.getName();
        }
        return "";
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public IStdField getStdField() {
        return this.stdField;
    }

    public Class<? extends IDict> getDictClass() {
        return this.dictClass;
    }

    public String getDictCode() {
        return this.dictCode;
    }

    public String getTitle() {
        return this.title;
    }

    public int getLength() {
        return this.length;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getViewLength() {
        if (this.viewLength <= 0) {
            this.viewLength = this.computeViewLength();
        }
        return this.viewLength;
    }

    public String getFormat() {
        return this.format;
    }

    private int computeViewLength() {
        if (this.title.length() * 2 < this.length) {
            return this.length;
        }
        int titleLength = this.title.chars().map(c -> c < 256 ? 1 : 2).sum();
        return Math.max(this.length, titleLength);
    }
}

