/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.metadata.field;

import com.shch.sfc.metadata.api.IStdField;
import com.shch.sfc.metadata.field.base.BaseStdField;
import com.shch.sfc.metadata.field.basedata.BasedataStdField;
import com.shch.sfc.metadata.field.bond.BondStdField;
import com.shch.sfc.metadata.field.cash.CashStdField;
import com.shch.sfc.metadata.field.cips.CipsStdField;
import com.shch.sfc.metadata.field.clear.ClearStdField;
import com.shch.sfc.metadata.field.cnaps.CnapsStdField;
import com.shch.sfc.metadata.field.fee.FeeStdField;
import com.shch.sfc.metadata.field.front.FrontStdField;
import com.shch.sfc.metadata.field.imix.ImixStdField;
import com.shch.sfc.metadata.field.member.MemberStdField;
import com.shch.sfc.metadata.field.risk.RiskStdField;
import com.shch.sfc.metadata.field.stp.StpStdField;
import com.shch.sfc.metadata.field.swift.SwiftStdField;
import java.util.HashMap;
import java.util.regex.Pattern;

public class StdFields {
    private static final HashMap<String, IStdField> FIELD_MAPPING = new HashMap(4096);
    private static final Pattern FIELD_NAME_PATTERN = Pattern.compile("(?<!_)[A-Z]");

    private static <T extends IStdField> void register(T[] fields) {
        for (T field : fields) {
            FIELD_MAPPING.put(field.name(), (IStdField)field);
        }
    }

    public static IStdField getField(String fieldName) {
        return FIELD_MAPPING.get(fieldName);
    }

    public static IStdField getFieldCamelCase(String camelName) {
        String fieldName = FIELD_NAME_PATTERN.matcher(camelName).replaceAll("_$0").toUpperCase();
        return StdFields.getField(fieldName);
    }

    private StdFields() {
    }

    static {
        StdFields.register((IStdField[])MemberStdField.values());
        StdFields.register((IStdField[])SwiftStdField.values());
        StdFields.register((IStdField[])CipsStdField.values());
        StdFields.register((IStdField[])CashStdField.values());
        StdFields.register((IStdField[])CnapsStdField.values());
        StdFields.register((IStdField[])FeeStdField.values());
        StdFields.register((IStdField[])FrontStdField.values());
        StdFields.register((IStdField[])ClearStdField.values());
        StdFields.register((IStdField[])BasedataStdField.values());
        StdFields.register((IStdField[])RiskStdField.values());
        StdFields.register((IStdField[])BondStdField.values());
        StdFields.register((IStdField[])ImixStdField.values());
        StdFields.register((IStdField[])BaseStdField.values());
        StdFields.register((IStdField[])StpStdField.values());
    }
}

