/*
 * Decompiled with CFR 0.152.
 */
package com.shch.sfc.metadata.dict;

import com.shch.sfc.metadata.api.IDict;
import com.shch.sfc.metadata.api.IDictFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class Dicts {
    private static final ConcurrentHashMap<String, IDict> DICT_VALUE_CACHE = new ConcurrentHashMap();
    private static final List<IDictFactory> FACTORYS = new ArrayList<IDictFactory>();
    private static final List<String> PACKAGES = new ArrayList<String>();
    private static final ThreadLocal<Dicts> LOCAL_INSTANCE = new ThreadLocal();
    private final HashMap<String, IDict> instanceCache = new HashMap();

    public static Dicts fromThreadLocal() {
        Dicts instance = LOCAL_INSTANCE.get();
        if (instance == null) {
            instance = new Dicts();
            LOCAL_INSTANCE.set(instance);
        }
        return instance;
    }

    public static void clearThreadLocal() {
        LOCAL_INSTANCE.remove();
    }

    public static IDict valueOf(Class<? extends IDict> dictClass, String value) {
        if (value == null) {
            return null;
        }
        String key = dictClass.getSimpleName() + "$" + value;
        return DICT_VALUE_CACHE.computeIfAbsent(key, k -> {
            IDict[] items = (IDict[])dictClass.getEnumConstants();
            return Arrays.stream(items).filter(i -> value.equals(i.value()) || value.equals(i.itemName()) || value.equals(i.itemNameEn())).findAny().orElse(null);
        });
    }

    public static Class<? extends IDict> tryFindEnumClass(String dictCode) {
        for (String pack : PACKAGES) {
            String className = pack + dictCode;
            try {
                return Dicts.class.getClassLoader().loadClass(className).asSubclass(IDict.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public IDict valueOf(String dictCode, String value) {
        String prefix = dictCode + "$";
        String key = prefix + value;
        if (DICT_VALUE_CACHE.containsKey(key)) {
            return DICT_VALUE_CACHE.get(key);
        }
        if (!this.instanceCache.containsKey(prefix)) {
            Class<? extends IDict> enumClass = Dicts.tryFindEnumClass(dictCode);
            if (enumClass != null && enumClass.isEnum()) {
                this.cache(Arrays.stream(enumClass.getEnumConstants()), prefix);
            } else {
                this.cache(FACTORYS.stream().flatMap(f -> Arrays.stream(f.createDictItems(dictCode))), prefix);
            }
            this.instanceCache.put(prefix, null);
        }
        return this.instanceCache.get(key);
    }

    private void cache(Stream<IDict> stream, String prefix) {
        stream.forEach(d -> {
            this.instanceCache.put(prefix + d.value(), (IDict)d);
            this.instanceCache.put(prefix + d.itemName(), (IDict)d);
            if (d.itemNameEn() != null && !d.itemNameEn().isEmpty()) {
                this.instanceCache.put(prefix + d.itemNameEn(), (IDict)d);
            }
        });
    }

    private Dicts() {
    }

    static {
        ServiceLoader.load(IDictFactory.class).forEach(FACTORYS::add);
        PACKAGES.add("com.shch.sfc.metadata.dict.stp.");
        PACKAGES.add("com.shch.sfc.metadata.dict.cips.");
        PACKAGES.add("com.shch.sfc.metadata.dict.bond.");
        PACKAGES.add("com.shch.sfc.metadata.dict.risk.");
        PACKAGES.add("com.shch.sfc.metadata.dict.front.");
        PACKAGES.add("com.shch.sfc.metadata.dict.basedata.");
        PACKAGES.add("com.shch.sfc.metadata.dict.base.");
        PACKAGES.add("com.shch.sfc.metadata.dict.cnaps.");
        PACKAGES.add("com.shch.sfc.metadata.dict.swift.");
        PACKAGES.add("com.shch.sfc.metadata.dict.cash.");
        PACKAGES.add("com.shch.sfc.metadata.dict.imix.");
        PACKAGES.add("com.shch.sfc.metadata.dict.fee.");
        PACKAGES.add("com.shch.sfc.metadata.dict.clear.");
        PACKAGES.add("com.shch.sfc.metadata.dict.member.");
    }
}

