package fox.ninetales.webview;

import android.graphics.Bitmap;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.webkit.ClientCertRequest;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import fox.ninetales.engine.FXHttpAuthHandler;
import fox.ninetales.engine.FXSslError;
import fox.ninetales.engine.FXWebClient;
import fox.ninetales.engine.FXWebView;

/**
 * WebView Client
 */
public class DefWebViewClient extends WebViewClient {

    /**
     * webview
     */
    private FXWebView webView;

    /**
     * web client
     */
    private FXWebClient webClient;

    /**
     * 构造函数
     * @param webView
     * @param webClient
     */
    public DefWebViewClient(FXWebView webView,FXWebClient webClient){
        this.webView=webView;
        this.webClient=webClient;
    }

    /**
     * 是否在 WebView 内加载页面
     *
     * @param view
     * @param request
     * @return
     */
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request){
        String url = request.getUrl().toString();
        return this.webClient.shouldOverrideUrlLoading(this.webView,url);
    }


    /**
     * WebView 开始加载页面时回调，一次Frame加载对应一次回调
     *
     * @param view
     * @param url
     * @param favicon
     */
    public void onPageStarted(WebView view, String url, Bitmap favicon){
        this.webClient.onPageStarted(this.webView,url);
    }

    /**
     * WebView 完成加载页面时回调，一次Frame加载对应一次回调
     *
     * @param view
     * @param url
     */
    public void onPageFinished(WebView view, String url){
        this.webClient.onPageFinished(this.webView,url);
    }

    /**
     * WebView 可以拦截某一次的 request 来返回我们自己加载的数据，这个方法在后面缓存会有很大作用。
     *
     * @param view    WebView
     * @param request 当前产生 request 请求
     * @return WebResourceResponse
     */
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request){
        return this.webClient.shouldInterceptRequest(this.webView,request);
    }

    /**
     * WebView 访问 url 出错
     *
     * @param view
     * @param request
     * @param error
     */
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error){
        this.webClient.onReceivedError(this.webView,error.getErrorCode(),
                error.getDescription().toString(),request.getUrl().toString());
    }

    /**
     * WebView ssl 访问证书出错，handler.cancel()取消加载，handler.proceed()对然错误也继续加载
     *
     * @param view
     * @param handler
     * @param error
     */
    public void onReceivedSslError(WebView view, SslErrorHandler handler, final SslError error){
        DefSslErrorHandler sslErrorHandler=new DefSslErrorHandler(handler);
        FXSslError sslError = new FXSslError() {
            @Override
            public SslCertificate getCertificate() {
                return error.getCertificate();
            }

            @Override
            public boolean addError(int errorVal) {
                return error.addError(errorVal);
            }

            @Override
            public boolean hasError(int errorVal) {
                return error.hasError(errorVal);
            }

            @Override
            public int getPrimaryError() {
                return error.getPrimaryError();
            }
        };
        this.webClient.onReceivedSslError(this.webView,sslErrorHandler,sslError);
    }

    /**
     * 应用程序处理SSL客户端认证请求
     * @param view
     * @param request
     */
    public void onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
        this.webClient.onReceivedClientCertRequest(this.webView,request);
    }

    /**
     *  通知应用程序WebView接收到了一个Http auth的请求
     * @param view
     * @param handler
     * @param host
     * @param realm
     */
    public void onReceivedHttpAuthRequest(WebView view,
                                          final HttpAuthHandler handler, String host, String realm) {
        FXHttpAuthHandler httpAuthHandler=new FXHttpAuthHandler() {
            @Override
            public boolean useHttpAuthUsernamePassword() {
                return handler.useHttpAuthUsernamePassword();
            }

            @Override
            public void cancel() {
                handler.cancel();
            }

            @Override
            public void proceed(String username, String password) {
                handler.proceed(username, password);
            }

            @Override
            public boolean suppressDialog() {
                return false;
            }
        };
        this.webClient.onReceivedHttpAuthRequest(this.webView,httpAuthHandler,host,realm);
    }


}
