package fox.ninetales.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;


import java.util.Map;

import fox.ninetales.engine.FXJsInterface;
import fox.ninetales.engine.FXWebClient;
import fox.ninetales.engine.FXWebSettings;
import fox.ninetales.engine.FXWebUIClient;
import fox.ninetales.engine.FXWebView;

public class DefWebView extends FXWebView{

    /**
     * web view
     */
    private WebView webView;

    /**
     * Constructs a new WebView with a Context object.
     *
     * @param context a Context object used to access application assets
     */
    public DefWebView(Context context) {
        super(context);
        //创建web view
        this.webView=new WebView(context);
        //设置web view填充容器
        LayoutParams layoutParams = new LayoutParams(LayoutParams.MATCH_PARENT,
                LayoutParams.MATCH_PARENT);
        this.webView.setLayoutParams(layoutParams);
        this.addView(this.webView);

        // 设置WebView属性，能够执行Javascript脚本
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setUseWideViewPort(true);
        this.webView.getSettings().setLoadWithOverviewMode(true);
        //设置可以支持缩放
        this.webView.getSettings().setSupportZoom(true);
        //设置出现缩放工具
        this.webView.getSettings().setBuiltInZoomControls(true);

        //是支持cookie支持
        if(android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP){
            CookieManager.getInstance().setAcceptCookie(true);
            CookieManager.getInstance().setAcceptThirdPartyCookies(webView,true);
        }

    }

    /**
     * Constructs a new WebView with layout parameters.
     *
     * @param context a Context object used to access application assets
     * @param attrs an AttributeSet passed to our parent
     */
    public DefWebView(Context context, AttributeSet attrs) {
        super(context,attrs);
        //创建web view
        this.webView=new WebView(context);
        //设置webview填充容器
        LayoutParams layoutParams = new LayoutParams(LayoutParams.MATCH_PARENT,
                LayoutParams.MATCH_PARENT);
        this.addView(this.webView,layoutParams);

        // 设置WebView属性，能够执行Javascript脚本
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setUseWideViewPort(true);
        this.webView.getSettings().setLoadWithOverviewMode(true);
        //设置可以支持缩放
        this.webView.getSettings().setSupportZoom(true);
        //设置出现缩放工具
        this.webView.getSettings().setBuiltInZoomControls(true);

        //是支持cookie支持
        if(android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP){
            CookieManager.getInstance().setAcceptCookie(true);
            CookieManager.getInstance().setAcceptThirdPartyCookies(webView,true);
        }
    }

    //销毁
    public void destroy(){
        if(this.webView!=null){
            this.webView.destroy();
        }
    }

    /**
     * Gets the WebSettings object used to control the settings for this
     * WebView.
     *
     * @return a WebSettings object that can be used to control this WebView's
     *         settings
     */
    public FXWebSettings getSettings(){
        WebSettings webSettings=this.webView.getSettings();
        return new DefWebSettings(webSettings);
    }

    /**
     * Sets the chrome the WebUIClient
     * @param client an implementation of FXWebUIClient
     */
    public void setWebUIClient(FXWebUIClient client){
        DefWebUIClient webUIClient=new DefWebUIClient(this,client);
        this.webView.setWebChromeClient(webUIClient);
    }

    /**
     * Sets the WebClient
     *
     * @param client an implementation of FXWebClient
     */
    public void setWebClient(FXWebClient client){
       DefWebViewClient webViewClient=new DefWebViewClient(this,client);
       this.webView.setWebViewClient(webViewClient);
    }

    /**
     * Gets the URL for the current page. This is not always the same as the URL
     * passed to WebViewClient.onPageStarted because although the load for
     * that URL has begun, the current page may not have changed.
     *
     * @return the URL for the current page
     */
    public String getUrl(){
        return this.webView.getUrl();
    }

    /**
     * Gets the original URL for the current page. This is not always the same
     * as the URL passed to WebViewClient.onPageStarted because although the
     * load for that URL has begun, the current page may not have changed.
     * Also, there may have been redirects resulting in a different URL to that
     * originally requested.
     *
     * @return the URL that was originally requested for the current page
     */
    public String getOriginalUrl(){
        return this.webView.getOriginalUrl();
    }

    /**
     * Loads the given URL with the specified additional HTTP headers.
     * <p>
     *
     * @param url the URL of the resource to load
     * @param additionalHttpHeaders the additional headers to be used in the
     *            HTTP request for this URL, specified as a map from name to
     *            value. Note that if this map contains any of the headers
     *            that are set by default by this WebView, such as those
     *            controlling caching, accept types or the User-Agent, their
     *            values may be overriden by this WebView's defaults.
     */
    public void loadUrl(String url, Map<String, String> additionalHttpHeaders){
        this.webView.loadUrl(url,additionalHttpHeaders);
        this.webView.getOriginalUrl();
    }

    /**
     * Loads the given URL.
     * <p>
     *
     * @param url the URL of the resource to load
     */
    public void loadUrl(String url){
        this.webView.loadUrl(url);
    }

    /**
     *  Add a new injected Java object from this WebView
     * @param fxJsInterface
     * @param name
     */
    @SuppressLint("JavascriptInterface")
    public void addJavascriptInterface(FXJsInterface fxJsInterface, String name){
        WrapJsInterface wrapJsInterface=new WrapJsInterface(fxJsInterface);
        this.webView.addJavascriptInterface(wrapJsInterface,name);
    }

    /**
     *  Removes a previously injected Java object from this WebView
     * @param name
     */
    @JavascriptInterface
    public void removeJavascriptInterface(String name){
        this.webView.removeJavascriptInterface(name);
    }

    /**
     * Asynchronously evaluates JavaScript in the context of the currently displayed page.
     * If non-null, |resultCallback| will be invoked with any result returned from that
     * execution. This method must be called on the UI thread and the callback will
     * be made on the UI thread.
     * <p>
     * @param script the JavaScript to execute.
     * @param resultCallback A callback to be invoked when the script execution
     *                       completes with the result of the execution (if any).
     *                       May be null if no notificaion of the result is required.
     */
    public void evaluateJavascript(String script, ValueCallback<String> resultCallback){
        this.webView.evaluateJavascript(script,resultCallback);
    }

    /**
     * 设置web view debug enable
     * @param enabled
     */
    public void setWebContentsDebuggingEnabled(boolean enabled){
        WebView.setWebContentsDebuggingEnabled(enabled);
    }

    /**
     * Wrap Javascript Interface
     */
    private class WrapJsInterface{

        /**
         * Javascript Interface
         */
        private FXJsInterface fxJsInterface;

        /**
         * 构造函数
         * @param fxJsInterface
         */
        public WrapJsInterface(FXJsInterface fxJsInterface){
            this.fxJsInterface=fxJsInterface;
        }

        /**
         * 执行
         * @param serviceName
         * @param action
         * @param rawArgs
         * @param callbackId
         * @return
         */
        @JavascriptInterface
        public String exec(String serviceName, String action, String rawArgs, String callbackId){
            Object res = this.fxJsInterface.exec(serviceName, action, rawArgs, callbackId);
            if(res == null){
                return "";
            }
            String str  = res.toString();
            return str;
        }
    }
}
