package fox.ninetales.webview;

import android.net.Uri;
import android.webkit.ConsoleMessage;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;

import fox.ninetales.engine.FXJsResult;
import fox.ninetales.engine.FXWebUIClient;
import fox.ninetales.engine.FXWebView;

/**
 * default WebUIClient
 *
 * create by 江成
 */
public class DefWebUIClient extends WebChromeClient {

    /**
     * web view
     */
    private FXWebView webView;

    /**
     * web UI client
     */
    private FXWebUIClient webUIClient;

    /**
     * 构造函数
     *
     * @param webView
     * @param webUIClient
     */
    public DefWebUIClient(FXWebView webView,FXWebUIClient webUIClient){
        this.webView=webView;
        this.webUIClient=webUIClient;
    }

    /**
     * 进度处理
     * @param view
     * @param newProgress
     */
    public void onProgressChanged(WebView view, int newProgress) {
        this.webUIClient.onProgressChanged(this.webView, newProgress);
    }

    /**
     * 处理console日志
     * @param consoleMessage
     * @return
     */
    public boolean onConsoleMessage(ConsoleMessage consoleMessage){
        return this.webUIClient.onConsoleMessage(consoleMessage);
    }


    /**
     * Js 中调用 alert() 函数，产生的对话框
     *
     * @param view
     * @param url
     * @param message
     * @param result
     * @return
     */
    public boolean onJsAlert(WebView view, String url, String message, final JsResult result){
       //创建JS Result
        FXJsResult jsResult=new FXJsResult() {
            @Override
            public void confirmWithResult(String result) {
                //do nothing
            }
            @Override
            public void cancel() {
               result.cancel();
            }
            @Override
            public void confirm() {
               result.confirm();
            }
        };
        return this.webUIClient.onJsAlert(this.webView,url,message,jsResult);
    }

    /**
     * 处理 Js 中的 Confirm 对话框
     *
     * @param view
     * @param url
     * @param message
     * @param result
     * @return
     */
    public boolean onJsConfirm(WebView view, String url, String message, final JsResult result){
        //创建JS Result
        FXJsResult jsResult=new FXJsResult() {
            @Override
            public void confirmWithResult(String result) {
                //do nothing
            }
            @Override
            public void cancel() {
                result.cancel();
            }
            @Override
            public void confirm() {
                result.confirm();
            }
        };
        return this.webUIClient.onJsConfirm(this.webView,url,message,jsResult);
    }

    /**
     * 处理 JS 中的 Prompt对话框
     *
     * @param view
     * @param url
     * @param message
     * @param defaultValue
     * @param result
     * @return
     */
    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, final JsPromptResult result){
        //创建JS Result
        FXJsResult jsResult=new FXJsResult() {
            @Override
            public void confirmWithResult(String res) {
                 result.confirm(res);
            }
            @Override
            public void cancel() {
                result.cancel();
            }
            @Override
            public void confirm() {
                result.confirm();
            }
        };
        return this.webUIClient.onJsPrompt(this.webView,url,message,defaultValue,jsResult);
    }


    /**
     * Tell the client to show a file chooser.
     * @param view
     * @param filePathCallback
     * @param fileChooserParams
     * @return
     */
    public boolean onShowFileChooser(WebView view, ValueCallback<Uri[]> filePathCallback,
                              WebChromeClient.FileChooserParams fileChooserParams){
        return this.webUIClient.onShowFileChooser(this.webView, filePathCallback, fileChooserParams);
    }

}
