package fox.ninetales.webview;

import android.webkit.WebSettings;

import fox.ninetales.engine.FXWebSettings;

/**
 * default WebView setting
 */
public class DefWebSettings implements FXWebSettings{

    /**
     * WebView setting
     */
    private WebSettings settings;

    /**
     * 构造函数
     * @param settings
     */
    public DefWebSettings(WebSettings settings){
       this.settings=settings;
    }

    /**
     * 是否支持JS
     * @param enabled
     */
    public void setJavaScriptEnabled(boolean enabled){
        this.settings.setJavaScriptEnabled(enabled);
    }

    /**
     * 判断是否支持JS
     *
     * @return
     */
    public boolean getJavaScriptEnabled(){
        return this.settings.getJavaScriptEnabled();
    }

    /**
     * 是否开启DOM缓存
     * @param enabled
     */
    public void setDomStorageEnabled(boolean enabled){
        this.settings.setDomStorageEnabled(enabled);
    }

    /**
     * 获取是否开启DOM缓存
     *
     * @return
     */
    public boolean getDomStorageEnabled(){
        return this.settings.getDomStorageEnabled();
    }

    /**
     * 开启数据库缓存
     * @param enabled
     */
    public void setDatabaseEnabled(boolean enabled){
        this.settings.setDomStorageEnabled(enabled);
    }

    /**
     * 获取开启数据库缓存
     * @return
     */
    public boolean getDatabaseEnabled(){
        return this.settings.getDatabaseEnabled();
    }

    /**
     * 设置缓存模式
     * @param mode
     */
    public void setCacheMode(int mode){
        this.settings.setCacheMode(mode);
    }

    /**
     * 获取缓存模式
     * @return
     */
    public int getCacheMode(){
        return this.getCacheMode();
    }

    /**
     * 设置允许加载本地html文件
     * @param allow
     */
    public void setAllowFileAccess(boolean allow){
        this.settings.setAllowFileAccess(allow);
    }

    /**
     * 获取是否允许加载本地html文件
     * @return
     */
    public boolean getAllowFileAccess(){
        return this.settings.getAllowFileAccess();
    }

    /**
     * 设置允许通过 file url 加载的 Javascript 读取其他的本地文件
     * @param allow
     */
    public void setAllowFileAccessFromFileURLs(boolean allow){
        this.settings.setAllowFileAccessFromFileURLs(allow);
    }

    /**
     * 获取是否允许通过 file url 加载的 Javascript 读取其他的本地文件
     * @return
     */
    public boolean getAllowFileAccessFromFileURLs(){
        return this.settings.getAllowFileAccessFromFileURLs();
    }

    /**
     * 允许通过 file url 加载的 Javascript 可以访问其他的源，包括其他的文件和 http，https 等其他资源
     * @param allow
     */
    public void setAllowUniversalAccessFromFileURLs(boolean allow){
         this.settings.setAllowUniversalAccessFromFileURLs(allow);
    }

    /**
     * 获取是否允许通过 file url 加载的 Javascript 可以访问其他的源，包括其他的文件和 http，https 等其他资源
     * @return
     */
    public boolean getAllowUniversalAccessFromFileURLs(){
        return this.settings.getAllowUniversalAccessFromFileURLs();
    }

    /**
     * 设置代理名称
     * @param ua
     */
    public void setUserAgentString(String ua){
        this.settings.setUserAgentString(ua);
    }

    /**
     * 获取代理名称
     * @return
     */
    public String getUserAgentString(){
        return this.settings.getUserAgentString();
    }

    /**
     * 设置字体大小比例
     * @param textZoom
     */
    public void setTextZoom(int textZoom){
        this.settings.setTextZoom(textZoom);
    }

    /**
     * 设置use
     * @param use
     */
    public void setUseWideViewPort(boolean use){
        this.settings.setUseWideViewPort(use);
    }

    /**
     * 设置overview mode
     * @param mode
     */
    public void setLoadWithOverviewMode(boolean mode){
        this.settings.setLoadWithOverviewMode(mode);
    }

    /**
     * 设置是否需要手势才播放多媒体
     * @param require
     */
    public void setMediaPlaybackRequiresUserGesture(boolean require){
       this.settings.setMediaPlaybackRequiresUserGesture(require);
    }
}
