/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class RAMPager<T> {
    private List<T> data;
    private int pageSize;

    public RAMPager(List<T> data, int pageSize) {
        this.data = data;
        this.pageSize = pageSize;
    }

    public List<T> page(int pageNum) {
        int to;
        int from;
        if (pageNum < 1) {
            pageNum = 1;
        }
        if ((from = (pageNum - 1) * this.pageSize) > (to = Math.min(pageNum * this.pageSize, this.data.size()))) {
            from = to;
        }
        return this.data.subList(from, to);
    }

    public int getPageCount() {
        if (this.pageSize == 0) {
            return 0;
        }
        return this.data.size() % this.pageSize == 0 ? this.data.size() / this.pageSize : this.data.size() / this.pageSize + 1;
    }

    public Iterator<List<T>> iterator() {
        return new Itr();
    }

    public static void main(String[] args) {
        List<Integer> list = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8);
        System.out.println("\u539f\u59cb\u6570\u636e\u662f\uff1a" + list);
        int pageSize = 2;
        System.out.println("\u6bcf\u9875\u5927\u5c0f\u662f\uff1a" + pageSize);
        RAMPager<Integer> pager = new RAMPager<Integer>(list, pageSize);
        System.out.println("\u603b\u9875\u6570\u662f: " + pager.getPageCount());
        System.out.println("<- - - - - - - - - - - - - ->");
        Iterator<List<Integer>> iterator = pager.iterator();
        while (iterator.hasNext()) {
            List<Integer> next = iterator.next();
            System.out.println("next: " + next);
        }
        System.out.println("<- - - - - - - - - - - - - ->");
        for (int i = 1; i <= pager.getPageCount(); ++i) {
            List<Integer> page = pager.page(i);
            System.out.println("\u7b2c " + i + " \u9875\u6570\u636e\u662f:" + page);
        }
    }

    private class Itr
    implements Iterator<List<T>> {
        int page = 1;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.page <= RAMPager.this.getPageCount();
        }

        @Override
        public List<T> next() {
            int i = this.page;
            if (i > RAMPager.this.getPageCount()) {
                return new ArrayList();
            }
            this.page = i + 1;
            return RAMPager.this.page(i);
        }
    }
}

