/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.tool.transaction;

import cn.com.yusys.yusp.commons.fee.common.component.Action;
import cn.com.yusys.yusp.commons.fee.common.enums.TransactionType;
import cn.com.yusys.yusp.commons.fee.common.operation.TransactionOperations;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class FeeTransactionManager
implements TransactionOperations {
    private static ThreadLocal<HashSet<TransactionStatus>> TRANSACTIONSTATUS_LIST = ThreadLocal.withInitial(HashSet::new);
    private static final Logger logger = LoggerFactory.getLogger(FeeTransactionManager.class);
    @Autowired(required=false)
    private DataSourceTransactionManager dataSourceTransactionManager;

    public Object begin() {
        if (!ObjectUtils.isEmpty((Object)this.dataSourceTransactionManager)) {
            TransactionStatus transaction = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionAttribute());
            return transaction;
        }
        return null;
    }

    public Object beginNew() {
        if (ObjectUtils.isEmpty((Object)this.dataSourceTransactionManager)) {
            return null;
        }
        DefaultTransactionDefinition transDefinition = new DefaultTransactionDefinition();
        transDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)transDefinition);
        return transaction;
    }

    public Object doBegin(Action action) {
        if (!ObjectUtils.isEmpty((Object)this.dataSourceTransactionManager)) {
            TransactionStatus transaction = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionAttribute());
            return transaction;
        }
        return null;
    }

    public void commit(Action currentAction, Object status) {
        String transactionType;
        if (status == null) {
            return;
        }
        if (status instanceof TransactionStatus && !StringUtils.isEmpty((Object)(transactionType = currentAction.getTransaction()))) {
            if (transactionType.equals(TransactionType.NEW.getValue())) {
                this.commit(status);
                logger.info("Transaction commit, transaction type: independent, component ID: {}", (Object)currentAction.getId());
            } else if (transactionType.equals(TransactionType.REQUIRED.getValue())) {
                TRANSACTIONSTATUS_LIST.get().add((TransactionStatus)status);
                logger.info("Transaction commit, transaction type:  global, component ID: {}", (Object)currentAction.getId());
            }
        }
    }

    public void commit(Object status) {
        if (status != null && status instanceof TransactionStatus) {
            this.dataSourceTransactionManager.commit((TransactionStatus)status);
        }
    }

    public void rollback(Object status) {
        if (status != null && status instanceof TransactionStatus) {
            this.dataSourceTransactionManager.rollback((TransactionStatus)status);
        }
    }

    public void allCommit(HashSet<Object> list) {
        if (!list.isEmpty()) {
            for (Object status : list) {
                if (!(status instanceof TransactionStatus)) continue;
                this.dataSourceTransactionManager.commit((TransactionStatus)status);
            }
            logger.info("Transaction commit, transaction type: global");
        }
    }

    public void allRollback(HashSet<Object> list) {
        if (!list.isEmpty()) {
            for (Object status : list) {
                if (!(status instanceof TransactionStatus)) continue;
                this.dataSourceTransactionManager.rollback((TransactionStatus)status);
            }
            logger.info("Transaction rollback, transaction type: global");
        }
    }
}

