/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.tool.config;

import cn.com.yusys.yusp.commons.fee.tool.DBAccessor;
import cn.com.yusys.yusp.commons.fee.tool.redis.BaseRedisOperations;
import cn.com.yusys.yusp.commons.fee.tool.redis.RedisLogic;
import cn.com.yusys.yusp.commons.fee.tool.transaction.FeeTransactionManager;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class FeeToolAutoConfiguration {
    @Bean(value={"feeRedisTemplate"})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory factory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(factory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.findAndRegisterModules();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(om);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        template.setKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    @ConditionalOnClass(value={RedisTemplate.class})
    public BaseRedisOperations baseRedisOperation() {
        return new BaseRedisOperations();
    }

    @Bean
    @ConditionalOnClass(value={RedisTemplate.class})
    public RedisLogic redisLogic() {
        return new RedisLogic();
    }

    @Bean
    public DBAccessor dbAccessor() {
        return new DBAccessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.jdbc.datasource.DataSourceTransactionManager"})
    public FeeTransactionManager feeTransactionManager() {
        return new FeeTransactionManager();
    }
}

