/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.tool;

import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUtil {
    private static Logger logger = LoggerFactory.getLogger(DBUtil.class);
    private static char PLACE_HOLDER = (char)63;
    private static char SPACE = (char)32;
    private static char COMMA = (char)44;
    private static char RIGHT_BRACKETS = (char)41;
    private static char COLON = (char)58;

    private static int getEndIndex(String s, int formIndex) {
        int commaIndex = s.indexOf(COMMA, formIndex);
        int spaceIndex = s.indexOf(SPACE, formIndex);
        int rightBrackets = s.indexOf(RIGHT_BRACKETS, formIndex);
        int index = commaIndex;
        if (spaceIndex != -1 && (index == -1 || index > spaceIndex)) {
            index = spaceIndex;
        }
        if (rightBrackets != -1 && (index == -1 || index > rightBrackets)) {
            index = rightBrackets;
        }
        return index;
    }

    public static PreparedStatement createPreparedStatement(String dbType, Connection con, String sql, Map<String, ?> paramMap) throws Exception {
        ArrayList parameters = new ArrayList();
        StringBuilder preSql = new StringBuilder();
        int index = 0;
        int sIndex = 0;
        int eIndex = 0;
        int len = sql.length();
        index = sql.indexOf(COLON);
        while (index != -1 && index < len) {
            String mark;
            eIndex = DBUtil.getEndIndex(sql, index + 1);
            if (eIndex == -1) {
                eIndex = len;
            }
            if (!paramMap.containsKey(mark = sql.substring(index + 1, eIndex))) {
                preSql.append(sql.substring(sIndex, eIndex));
                logger.warn("the illegal place holder[" + mark + "],sql:" + sql);
            } else {
                preSql.append(sql.substring(sIndex, index));
                preSql.append(PLACE_HOLDER);
                Object value = paramMap.get(mark);
                parameters.add(value);
            }
            sIndex = eIndex;
            if (eIndex == len) break;
            index = sql.indexOf(COLON, sIndex);
        }
        if (sIndex < len) {
            preSql.append(sql.substring(sIndex));
        }
        PreparedStatement stm = con.prepareStatement(preSql.toString());
        int size = parameters.size();
        for (int i = 0; i < size; ++i) {
            DBUtil.setData(stm, i + 1, parameters.get(i), dbType);
        }
        return stm;
    }

    public static PreparedStatement createPreparedStatement(String dbType, Connection con, String sql, Object ... args) throws Exception {
        PreparedStatement stm = con.prepareStatement(sql.toString());
        int size = args.length;
        for (int i = 0; i < size; ++i) {
            DBUtil.setData(stm, i + 1, args[i], dbType);
        }
        return stm;
    }

    public static String setSql(String sql) {
        StringBuilder preSql = new StringBuilder();
        int index = 0;
        int sIndex = 0;
        int eIndex = 0;
        int len = sql.length();
        index = sql.indexOf(COLON);
        while (index != -1 && index < len) {
            eIndex = DBUtil.getEndIndex(sql, index + 1);
            if (eIndex == -1) {
                eIndex = len;
            }
            String mark = sql.substring(index + 1, eIndex);
            preSql.append(sql.substring(sIndex, index));
            preSql.append(PLACE_HOLDER);
            sIndex = eIndex;
            if (eIndex == len) break;
            index = sql.indexOf(COLON, sIndex);
        }
        if (sIndex < len) {
            preSql.append(sql.substring(sIndex));
        }
        return preSql.toString();
    }

    public static PreparedStatement createPreparedStatement(String dbType, Connection con, String sql, Object obj) throws Exception {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder preSql = new StringBuilder();
        int index = 0;
        int sIndex = 0;
        int eIndex = 0;
        int len = sql.length();
        index = sql.indexOf(COLON);
        while (index != -1 && index < len) {
            eIndex = DBUtil.getEndIndex(sql, index + 1);
            if (eIndex == -1) {
                eIndex = len;
            }
            preSql.append(sql.substring(sIndex, index));
            preSql.append(PLACE_HOLDER);
            parameters.add(obj);
            sIndex = eIndex;
            if (eIndex == len) break;
            index = sql.indexOf(COLON, sIndex);
        }
        if (sIndex < len) {
            preSql.append(sql.substring(sIndex));
        }
        PreparedStatement stm = con.prepareStatement(preSql.toString());
        int size = parameters.size();
        for (int i = 0; i < size; ++i) {
            DBUtil.setData(stm, i + 1, parameters.get(i), dbType);
        }
        return stm;
    }

    public static CallableStatement createPreparedCall(String dbType, Connection con, String call, Map<String, ?> paramMap) throws Exception {
        ArrayList parameters = new ArrayList();
        StringBuilder preCall = new StringBuilder();
        int index = 0;
        int sIndex = 0;
        int eIndex = 0;
        int len = call.length();
        index = call.indexOf(COLON);
        while (index != -1 && index < len) {
            String mark;
            eIndex = DBUtil.getEndIndex(call, index + 1);
            if (eIndex == -1) {
                eIndex = len;
            }
            if (!paramMap.containsKey(mark = call.substring(index + 1, eIndex))) {
                preCall.append(call.substring(sIndex, eIndex));
                logger.warn("the illegal place holder[" + mark + "],call:" + call);
            } else {
                preCall.append(call.substring(sIndex, index));
                preCall.append(PLACE_HOLDER);
                Object value = paramMap.get(mark);
                parameters.add(value);
            }
            sIndex = eIndex;
            if (eIndex == len) break;
            index = call.indexOf(COLON, sIndex);
        }
        if (sIndex < len) {
            preCall.append(call.substring(sIndex));
        }
        CallableStatement stm = con.prepareCall(preCall.toString());
        int size = parameters.size();
        for (int i = 0; i < size; ++i) {
            DBUtil.setData(stm, i + 1, parameters.get(i), dbType);
        }
        return stm;
    }

    public static CallableStatement createFunctionCall(String dbType, Connection con, String call, int outType, Map<String, ?> paramMap) throws Exception {
        ArrayList parameters = new ArrayList();
        StringBuilder preCall = new StringBuilder();
        int index = 0;
        int sIndex = 0;
        int eIndex = 0;
        int len = call.length();
        index = call.indexOf(COLON);
        while (index != -1 && index < len) {
            String mark;
            eIndex = DBUtil.getEndIndex(call, index + 1);
            if (eIndex == -1) {
                eIndex = len;
            }
            if (!paramMap.containsKey(mark = call.substring(index + 1, eIndex))) {
                preCall.append(call.substring(sIndex, eIndex));
                logger.warn("the illegal place holder[" + mark + "],call:" + call);
            } else {
                preCall.append(call.substring(sIndex, index));
                preCall.append(PLACE_HOLDER);
                Object value = paramMap.get(mark);
                parameters.add(value);
            }
            sIndex = eIndex;
            if (eIndex == len) break;
            index = call.indexOf(COLON, sIndex);
        }
        if (sIndex < len) {
            preCall.append(call.substring(sIndex));
        }
        CallableStatement stm = con.prepareCall(preCall.toString());
        stm.registerOutParameter(1, outType);
        int size = parameters.size();
        for (int i = 0; i < size; ++i) {
            DBUtil.setData(stm, i + 2, parameters.get(i), dbType);
        }
        return stm;
    }

    public static CallableStatement createPreparedCall(String dbType, Connection con, String sql, Object ... args) throws Exception {
        CallableStatement stm = con.prepareCall(sql.toString());
        int size = args.length;
        for (int i = 0; i < size; ++i) {
            DBUtil.setData(stm, i + 1, args[i], dbType);
        }
        return stm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> convertResultSetToMap(ResultSet rs, String dbType) throws Exception {
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
        ResultSetMetaData resMeta = rs.getMetaData();
        int count = resMeta.getColumnCount();
        while (rs.next()) {
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            for (int i = 1; i <= count; ++i) {
                String columnName = resMeta.getColumnName(i);
                Object value = rs.getObject(i);
                if (value != null) {
                    Class<?> clazz = value.getClass();
                    if (Blob.class.isAssignableFrom(clazz)) {
                        Blob blob = (Blob)value;
                        int len = (int)blob.length();
                        byte[] bytes = new byte[len];
                        try (InputStream in = blob.getBinaryStream();){
                            in.read(bytes);
                            value = bytes;
                        }
                    }
                    if (Clob.class.isAssignableFrom(clazz)) {
                        Clob clob = (Clob)value;
                        try (Reader reader = clob.getCharacterStream();){
                            int len = (int)clob.length();
                            char[] chars = new char[len];
                            reader.read(chars);
                            value = new String(chars);
                        }
                    }
                    switch (dbType) {
                        case "ORACLE": {
                            if (!Date.class.isAssignableFrom(clazz)) break;
                            value = new java.util.Date(rs.getTimestamp(i).getTime());
                        }
                    }
                }
                rowMap.put(columnName.toLowerCase(), value);
            }
            resList.add(rowMap);
        }
        return resList;
    }

    public static List<Map<String, Object>> convertResultSetToMap(ResultSet rs, Map<String, Class<?>> resTypeMap, String dbType) throws Exception {
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
        ResultSetMetaData resMeta = rs.getMetaData();
        int count = resMeta.getColumnCount();
        if (count == 0) {
            return resList;
        }
        while (rs.next()) {
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            for (int i = 1; i <= count; ++i) {
                Class<?> expectedType = null;
                String columnName = resMeta.getColumnName(i);
                expectedType = resTypeMap.get(columnName);
                if (expectedType == null) {
                    columnName = columnName.toUpperCase();
                    expectedType = resTypeMap.get(columnName);
                }
                if (expectedType == null) {
                    columnName = columnName.toLowerCase();
                    expectedType = resTypeMap.get(columnName);
                }
                if (expectedType == null) {
                    throw new Exception("can not found corresponding type for column[" + columnName + "]");
                }
                Object value = DBUtil.getData(rs, i, expectedType, dbType);
                rowMap.put(columnName, value);
            }
            resList.add(rowMap);
        }
        return resList;
    }

    public static <T> List<T> convertResultSetToBean(ResultSet rs, Class<T> type, String dbType) throws Exception {
        ArrayList<T> resList = new ArrayList<T>();
        ResultSetMetaData resMeta = rs.getMetaData();
        int count = resMeta.getColumnCount();
        if (count == 0) {
            return resList;
        }
        Map fieldMap = ClassUtil.getFields(type);
        HashMap<String, Field> beanFieldMap = new HashMap<String, Field>();
        for (Map.Entry entry : fieldMap.entrySet()) {
            String key = (String)entry.getKey();
            Field field = (Field)entry.getValue();
            key = key.toUpperCase();
            field.setAccessible(true);
            beanFieldMap.put(key, field);
        }
        while (rs.next()) {
            T bean = type.newInstance();
            for (int i = 1; i <= count; ++i) {
                String columnName = resMeta.getColumnName(i);
                Field field = (Field)beanFieldMap.get(columnName = columnName.toUpperCase());
                if (field == null) continue;
                Object value = DBUtil.getData(rs, i, field.getType(), dbType);
                field.set(bean, value);
            }
            resList.add(bean);
        }
        return resList;
    }

    private static void setData(PreparedStatement stm, int index, Object value, String dbType) throws SQLException {
        if (value == null) {
            stm.setObject(index, value);
            return;
        }
        Class<?> clazz = value.getClass();
        if (Byte.TYPE == clazz || Byte.class == clazz) {
            stm.setByte(index, (Byte)value);
        } else if (Short.TYPE == clazz || Short.class == clazz) {
            stm.setShort(index, (Short)value);
        } else if (Integer.TYPE == clazz || Integer.class == clazz) {
            stm.setInt(index, (Integer)value);
        } else if (Long.TYPE == clazz || Long.class == clazz) {
            stm.setLong(index, (Long)value);
        } else if (Float.TYPE == clazz || Float.class == clazz) {
            stm.setFloat(index, ((Float)value).floatValue());
        } else if (Double.TYPE == clazz || Double.class == clazz) {
            stm.setDouble(index, (Double)value);
        } else if (Character.TYPE == clazz || Character.class == clazz) {
            stm.setString(index, value.toString());
        } else if (Boolean.TYPE == clazz || Boolean.class == clazz) {
            stm.setBoolean(index, (Boolean)value);
        } else if (CharSequence.class.isAssignableFrom(clazz)) {
            stm.setString(index, value.toString());
        } else if (Time.class == clazz) {
            stm.setTime(index, (Time)value);
        } else if (Timestamp.class == clazz) {
            stm.setTimestamp(index, (Timestamp)value);
        } else if (java.util.Date.class.isAssignableFrom(clazz)) {
            if ("ORACLE".equals(dbType)) {
                if (clazz != Timestamp.class) {
                    java.util.Date date = (java.util.Date)value;
                    value = new Timestamp(date.getTime());
                }
                stm.setTimestamp(index, (Timestamp)value);
            } else {
                if (clazz != Date.class) {
                    java.util.Date date = (java.util.Date)value;
                    value = new Date(date.getTime());
                }
                stm.setDate(index, (Date)value);
            }
        } else if (byte[].class == clazz) {
            stm.setBytes(index, (byte[])value);
        } else if (Byte[].class == clazz) {
            Byte[] buffer = (Byte[])value;
            byte[] bytes = new byte[buffer.length];
            for (int i = 0; i < buffer.length; ++i) {
                bytes[i] = buffer[i];
            }
            stm.setBytes(index, bytes);
        } else if (BigDecimal.class == clazz) {
            stm.setBigDecimal(index, (BigDecimal)value);
        } else if (Blob.class.isAssignableFrom(clazz)) {
            stm.setBlob(index, (Blob)value);
        } else if (Clob.class.isAssignableFrom(clazz)) {
            stm.setClob(index, (Clob)value);
        } else {
            stm.setObject(index, value);
        }
    }

    private static Object getData(ResultSet rs, int index, Class<?> expectedType, String dbType) throws Exception {
        Object obj = rs.getObject(index);
        if (obj == null) {
            return obj;
        }
        Class<?> clazz = obj.getClass();
        if (Date.class.isAssignableFrom(clazz)) {
            switch (dbType) {
                case "ORACLE": {
                    if (!Date.class.isAssignableFrom(clazz)) break;
                    obj = new java.util.Date(rs.getTimestamp(index).getTime());
                }
            }
        }
        Object res = ClassUtil.convert((Object)obj, expectedType);
        return res;
    }
}

