/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.tool.redis;

import cn.com.yusys.yusp.commons.fee.common.ThreadLocalClean;
import cn.com.yusys.yusp.commons.fee.common.logic.DistributeLock;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.SetArgs;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.async.RedisScriptingAsyncCommands;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.StringUtils;

public class RedisDistributeLock
implements DistributeLock,
ThreadLocalClean,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(RedisDistributeLock.class);
    private ThreadLocal<Map<String, String>> lockValue = ThreadLocal.withInitial(HashMap::new);
    private static final String LOCK_SUCCESS = "OK";
    private static final String REDIS_LIB_MISMATCH = "Failed to convert nativeConnection. Is your SpringBoot version > 2.0 ? Only lib:lettuce is supported.";
    private static final String UNLOCK_LUA = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
    private static final String DEL_IF_NOT_EQUAL_LUA = "if redis.call('get', KEYS[1]) ~= ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
    @Autowired
    @Qualifier(value="feeRedisTemplate")
    private RedisTemplate redisTemplate;
    private StringRedisSerializer stringRedisSerializer;
    private Jackson2JsonRedisSerializer jackson2JsonRedisSerializer;

    public boolean lock(String key, long expiredTime, int retryTimes, long sleepMillis) {
        boolean result = this.lock(key, expiredTime);
        while (!result && retryTimes-- > 0) {
            try {
                logger.debug("lock failed, retrying..." + retryTimes);
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            result = this.lock(key, expiredTime);
        }
        return result;
    }

    public boolean lock(String key, long expiredTime) {
        String uuid = UUID.randomUUID().toString();
        boolean result = this.lock(key, uuid, expiredTime);
        if (result) {
            this.lockValue.get().put(key, uuid);
        }
        return result;
    }

    public boolean lock(String key, String lockValue, long expiredTime) {
        Boolean resultBoolean = (Boolean)this.redisTemplate.execute(connection -> {
            Object nativeConnection = connection.getNativeConnection();
            String redisResult = "";
            byte[] keyByte = this.stringRedisSerializer.serialize(key);
            byte[] valueByte = this.jackson2JsonRedisSerializer.serialize((Object)lockValue);
            if (nativeConnection instanceof RedisAsyncCommands) {
                RedisAsyncCommands commands = (RedisAsyncCommands)nativeConnection;
                redisResult = commands.getStatefulConnection().sync().set((Object)keyByte, (Object)valueByte, SetArgs.Builder.nx().ex(expiredTime));
            }
            if (nativeConnection instanceof RedisAdvancedClusterAsyncCommands) {
                RedisAdvancedClusterAsyncCommands clusterAsyncCommands = (RedisAdvancedClusterAsyncCommands)nativeConnection;
                redisResult = clusterAsyncCommands.getStatefulConnection().sync().set((Object)keyByte, (Object)keyByte, SetArgs.Builder.nx().ex(expiredTime));
            }
            return LOCK_SUCCESS.equalsIgnoreCase(redisResult);
        });
        return resultBoolean != null && resultBoolean != false;
    }

    public boolean releaseLock(String key, String lockValue) {
        return this.delByLua(key, lockValue, UNLOCK_LUA);
    }

    public boolean delByLua(String key, String lockValue, String delLua) {
        byte[] valueBytes;
        if (lockValue == null) {
            return false;
        }
        byte[] keyBytes = this.stringRedisSerializer.serialize(key);
        Long result = (Long)this.redisTemplate.execute(arg_0 -> this.lambda$delByLua$1(delLua, keyBytes, valueBytes = this.jackson2JsonRedisSerializer.serialize((Object)lockValue), arg_0));
        return result != null && result > 0L;
    }

    public boolean delIfNotEqual(String key, String lockValue) {
        return this.delByLua(key, lockValue, DEL_IF_NOT_EQUAL_LUA);
    }

    public boolean releaseLock(String key) {
        String value = this.lockValue.get().get(key);
        if (StringUtils.isEmpty((Object)value)) {
            return false;
        }
        boolean result = this.releaseLock(key, value);
        if (result) {
            this.lockValue.get().remove(key);
        }
        return result;
    }

    private Long getEvalResult(RedisFuture future) {
        try {
            Object o = future.get();
            return (Long)o;
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Future get failed.", (Throwable)e);
            return 0L;
        }
    }

    public boolean isLocked(String key) {
        Object o = this.redisTemplate.opsForValue().get((Object)key);
        return o != null;
    }

    public void afterPropertiesSet() throws Exception {
        this.stringRedisSerializer = new StringRedisSerializer();
        this.jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        this.jackson2JsonRedisSerializer.setObjectMapper(om);
    }

    public void clear() throws Exception {
        this.lockValue.remove();
    }

    private /* synthetic */ Long lambda$delByLua$1(String delLua, byte[] keyBytes, byte[] valueBytes, RedisConnection connection) throws DataAccessException {
        Object nativeConnection = connection.getNativeConnection();
        if (nativeConnection instanceof RedisScriptingAsyncCommands) {
            RedisScriptingAsyncCommands command = (RedisScriptingAsyncCommands)nativeConnection;
            RedisFuture future = command.eval(delLua, ScriptOutputType.INTEGER, new Object[]{keyBytes}, (Object[])new byte[][]{valueBytes});
            return this.getEvalResult(future);
        }
        logger.warn(REDIS_LIB_MISMATCH);
        return 0L;
    }
}

